package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理错误原因
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
public enum HandleFaultReason {

    _1("1", "文件下载异常"),
    _2("2", "文件转换异常"),
    _3("3", "数据入库异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HandleFaultReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleFaultReason fromCode(String code) {
        return Stream.of(HandleFaultReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
