package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 结算状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
public enum SettlementStatus {

    _0("0", "未结算"),
    _1("1", "已结算");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SettlementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementStatus fromCode(String code) {
        return Stream.of(SettlementStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
