package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订阅方名称
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
public enum SubscriberName {

    PURCHASE_ORDER_CREATE("PURCHASE_ORDER_CREATE", "采购单新增订阅"),
    PURCHASE_ORDER_UPDATE("PURCHASE_ORDER_UPDATE", "采购单修改订阅"),
    EMAIL("EMAIL", "邮件订阅");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SubscriberName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubscriberName fromCode(String code) {
        return Stream.of(SubscriberName.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
