package com.xforceplus.ultraman.app.jcunilever.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * mdm_sync
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MdmSync implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 处理状态
   */
  private String status;
  /**
   * 重试次数
   */
  private Long retryCount;
  /**
   * 处理错误原因
   */
  private String lastFaultReason;
  /**
   * 处理错误备注
   */
  private String remark;
  /**
   * 拉取日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime queryDate;
  /**
   * 上次拉取分页
   */
  private Long lastQueryPage;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 总数量
   */
  private Long totalCount;
  /**
   * 总页数
   */
  private Long pageCount;
  /**
   * 分页大小
   */
  private Long pageSize;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("status", status);
      map.put("retryCount", retryCount);
      map.put("lastFaultReason", lastFaultReason);
      map.put("remark", remark);
      map.put("queryDate", BocpGenUtils.toTimestamp(queryDate));
      map.put("lastQueryPage", lastQueryPage);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("totalCount", totalCount);
      map.put("pageCount", pageCount);
      map.put("pageSize", pageSize);

      return map;
  }

  public static MdmSync fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MdmSync entity = new MdmSync();

    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retryCount")) {
      Object obj = map.get("retryCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lastFaultReason")) {
      Object obj = map.get("lastFaultReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastFaultReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("queryDate")) {
      Object obj = map.get("queryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQueryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setQueryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQueryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setQueryDate(null);
      }
    }
    if(map.containsKey("lastQueryPage")) {
      Object obj = map.get("lastQueryPage");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastQueryPage((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastQueryPage(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLastQueryPage(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalCount")) {
      Object obj = map.get("totalCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTotalCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTotalCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pageCount")) {
      Object obj = map.get("pageCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPageCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pageSize")) {
      Object obj = map.get("pageSize");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPageSize((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPageSize(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPageSize(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retryCount")) {
      Object obj = map.get("retryCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lastFaultReason")) {
      Object obj = map.get("lastFaultReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastFaultReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("queryDate")) {
      Object obj = map.get("queryDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQueryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setQueryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQueryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setQueryDate(null);
      }
    }
    if(map.containsKey("lastQueryPage")) {
      Object obj = map.get("lastQueryPage");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLastQueryPage((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLastQueryPage(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setLastQueryPage(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalCount")) {
      Object obj = map.get("totalCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTotalCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTotalCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pageCount")) {
      Object obj = map.get("pageCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPageCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pageSize")) {
      Object obj = map.get("pageSize");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPageSize((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPageSize(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPageSize(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
  }
}
