package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 申请类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum ApplyType {

    _0("0", "下单"),
    _1("1", "退货退款"),
    _2("2", "导入创建");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyType fromCode(String code) {
        return Stream.of(ApplyType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
