package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum MakeInvoiceStatus {

    _0("0", "未开票"),
    _1("1", "已提交"),
    _2("2", "已开票"),
    _3("3", "已关闭"),
    _4("4", "已存在");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MakeInvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MakeInvoiceStatus fromCode(String code) {
        return Stream.of(MakeInvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
