package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * billing发票关系状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-24
 */
public enum BillingInvoiceRelationStatusEnum {

    _0("0", "作废"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillingInvoiceRelationStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillingInvoiceRelationStatusEnum fromCode(String code) {
        return Stream.of(BillingInvoiceRelationStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
