package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 客户类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-24
 */
public enum CustomerType {

    KC("KC", "商超客户"),
    DT("DT", "经销商"),
    BRANCH("Branch", "内部公司");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CustomerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustomerType fromCode(String code) {
        return Stream.of(CustomerType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
