package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 异常原因
 * </p>
 *
 * @author ultraman
 * @since 2023-03-24
 */
public enum ErrorReasonEnum {

    BILLING_FILE_ERROR("billingFileError", "Blob-billing文件异常"),
    BILLING_DATA_CHECK_ERROR("billingDataCheckError", "billing数据校验异常"),
    BILLING_M_D_M_INFO_COMPLETION_ERROR("billingMDMInfoCompletionError", "billing数据-MDM客户信息补全异常"),
    BILLING_BUSINESS_DEPT_COMPLETION_ERROR("billingBusinessDeptCompletionError", "billing数据-业务部门补全异常"),
    BILLING_DATA_SYNC_ERROR("billingDataSyncError", "billing数据同步异常"),
    M_D_M_DATA_CHECK_ERROR("MDMDataCheckError", "MDM数据校验异常"),
    BILLINGUPLOAD_TXT_ERROR("billinguploadTxtError", "billing上传txt异常"),
    BILLINGUPLOAD_EXCEL_ERROR("billinguploadExcelError", "billing上传Excel异常"),
    PROCESS_CREATE_INVOICE_ERROR("processCreateInvoiceError", "处理新增发票异常"),
    CREATE_BILLING_INVOICE_RELATION_ERROR("createBillingInvoiceRelationError", "保存billing发票关系数据异常"),
    SYSTEM_ERROR("systemError", "系统异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ErrorReasonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErrorReasonEnum fromCode(String code) {
        return Stream.of(ErrorReasonEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
