package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办任务主题
 * </p>
 *
 * @author ultraman
 * @since 2023-03-24
 */
public enum TodoTaskTopic {

    RECEIVE_ORDER_CREATE("RECEIVE_ORDER_CREATE", "收货单新增待办"),
    RECEIVE_ORDER_UPDATE("RECEIVE_ORDER_UPDATE", "收货单更新待办"),
    PURCHASE_ORDER_DELETE("PURCHASE_ORDER_DELETE", "采购单删除待办"),
    RECEIVE_ORDER_DELETE("RECEIVE_ORDER_DELETE", "收货单删除待办"),
    PURCHASE_ORDER_CREATE("PURCHASE_ORDER_CREATE", "采购单新增待办"),
    PURCHASE_ORDER_UPDATE("PURCHASE_ORDER_UPDATE", "采购单更新待办"),
    EMAIL("EMAIL", "邮件待办");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TodoTaskTopic(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TodoTaskTopic fromCode(String code) {
        return Stream.of(TodoTaskTopic.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
