package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办来源
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum ProduceSource {

    _1("1", "billing原始数据"),
    _2("2", "mdm原始数据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProduceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceSource fromCode(String code) {
        return Stream.of(ProduceSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
