package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum Whether {

    _1("1", "是"),
    _0("0", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Whether(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Whether fromCode(String code) {
        return Stream.of(Whether.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
