package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum InvoicingMode {

    _0("0", "按Billing单开票"),
    _1("1", "按结算单开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoicingMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoicingMode fromCode(String code) {
        return Stream.of(InvoicingMode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
