package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票金额与结算金额是否一致
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum IsConsistent {

    _0("0", "一致"),
    _1("1", "不一致");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsConsistent(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsConsistent fromCode(String code) {
        return Stream.of(IsConsistent.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
