package com.xforceplus.ultraman.app.jcunilever.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-06-01
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1518413358146510849L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface OrderDetail {
        static Long id() {
            return 1518875868503810050L;
        }
        static String code() {
            return "orderDetail";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> GOODS_ID = new TypedField<>(String.class, "goodsId");
        TypedField<String> GOODS_NAME = new TypedField<>(String.class, "goodsName");
        TypedField<String> SKU_CODE = new TypedField<>(String.class, "skuCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> GOODS_QUANTITY = new TypedField<>(BigDecimal.class, "goodsQuantity");
        TypedField<BigDecimal> GOODS_UNIT_PRICE = new TypedField<>(BigDecimal.class, "goodsUnitPrice");
        TypedField<BigDecimal> GOODS_AMOUNT = new TypedField<>(BigDecimal.class, "goodsAmount");
        TypedField<String> MAIN_ORDER_ID = new TypedField<>(String.class, "mainOrderId");
        /**
         * 对一关联关系 关联对象 orderPool
         */
        TypedField<Long> ORDER_DETAILS_ID = new TypedField<>(Long.class, "orderDetails.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ORDER_DETAILS {
                static String code () {
                    return "orderDetails" ;
                }
                TypedField<String> APPLY_NO = new TypedField<>(String.class, "orderDetails.applyNo");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "orderDetails.errorInfo");
                TypedField<String> STORE_ID = new TypedField<>(String.class, "orderDetails.storeId");
                TypedField<String> MAIN_ORDER_NO = new TypedField<>(String.class, "orderDetails.mainOrderNo");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "orderDetails.businessType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderDetails.orderType");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "orderDetails.purchaserName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "orderDetails.purchaserTaxNo");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "orderDetails.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "orderDetails.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "orderDetails.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "orderDetails.purchaserBankAccount");
                TypedField<String> APPLY_TYPE = new TypedField<>(String.class, "orderDetails.applyType");
                TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "orderDetails.applyTime");
                TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "orderDetails.settlementStatus");
                TypedField<String> MAKE_INVOICE_STATUS = new TypedField<>(String.class, "orderDetails.makeInvoiceStatus");
                TypedField<String> SUBMIT_INVOICE_STATUS = new TypedField<>(String.class, "orderDetails.submitInvoiceStatus");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "orderDetails.invoiceType");
                TypedField<String> HEADER_TYPE = new TypedField<>(String.class, "orderDetails.headerType");
                TypedField<BigDecimal> ORDER_TOTAL = new TypedField<>(BigDecimal.class, "orderDetails.orderTotal");
                TypedField<BigDecimal> GOODS_TOTAL = new TypedField<>(BigDecimal.class, "orderDetails.goodsTotal");
                TypedField<String> DATA_ORIG = new TypedField<>(String.class, "orderDetails.dataOrig");
                TypedField<BigDecimal> SETTLEMENT_TOTAL = new TypedField<>(BigDecimal.class, "orderDetails.settlementTotal");
                TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "orderDetails.invoiceAmount");
                TypedField<String> IS_CONSISTENT = new TypedField<>(String.class, "orderDetails.isConsistent");
                TypedField<BigDecimal> VERIFICATION_VARIANCE = new TypedField<>(BigDecimal.class, "orderDetails.verificationVariance");
                TypedField<LocalDateTime> CANCEL_TIME = new TypedField<>(LocalDateTime.class, "orderDetails.cancelTime");
                TypedField<String> CANCEL_REASON = new TypedField<>(String.class, "orderDetails.cancelReason");
                TypedField<Long> ID = new TypedField<>(Long.class, "orderDetails.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orderDetails.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orderDetails.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orderDetails.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orderDetails.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orderDetails.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orderDetails.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orderDetails.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orderDetails.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orderDetails.delete_flag");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "orderDetails.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "orderDetails.invoiceCode");
                TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "orderDetails.expressNumber");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "orderDetails.invoiceOrig");
                TypedField<String> FORCE_INVOICE = new TypedField<>(String.class, "orderDetails.forceInvoice");
                TypedField<LocalDateTime> MAKE_INVOICE_TIME = new TypedField<>(LocalDateTime.class, "orderDetails.makeInvoiceTime");
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "orderDetails.salesbillNo");
                TypedField<String> STORE_NAME = new TypedField<>(String.class, "orderDetails.storeName");
                TypedField<BigDecimal> ASSESSMENT_COUNT_DOWN = new TypedField<>(BigDecimal.class, "orderDetails.assessmentCountDown");
            }
        }
    }
    public interface SettlementPool {
        static Long id() {
            return 1519238049086672898L;
        }
        static String code() {
            return "settlementPool";
        }
        TypedField<String> REQUEST_NO = new TypedField<>(String.class, "requestNo");
        TypedField<String> SHOP_ORDER_ID = new TypedField<>(String.class, "shopOrderId");
        TypedField<String> ORDER_ID = new TypedField<>(String.class, "orderId");
        TypedField<BigDecimal> SETTLE_AMOUNT = new TypedField<>(BigDecimal.class, "settleAmount");
        TypedField<String> PAY_TYPE_DESC = new TypedField<>(String.class, "payTypeDesc");
        TypedField<String> TRADE_TYPE = new TypedField<>(String.class, "tradeType");
        TypedField<String> IS_CONTAINS_REFUND_BEFORE_SETTLE = new TypedField<>(String.class, "isContainsRefundBeforeSettle");
        TypedField<String> PRODUCT_ID = new TypedField<>(String.class, "productId");
        TypedField<BigDecimal> GOODS_COUNT = new TypedField<>(BigDecimal.class, "goodsCount");
        TypedField<String> FLOW_TYPE_DESC = new TypedField<>(String.class, "flowTypeDesc");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "totalAmount");
        TypedField<BigDecimal> TOTAL_GOODS_AMOUNT = new TypedField<>(BigDecimal.class, "totalGoodsAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> POST_AMOUNT = new TypedField<>(BigDecimal.class, "postAmount");
        TypedField<BigDecimal> SHOP_COUPON = new TypedField<>(BigDecimal.class, "shopCoupon");
        TypedField<BigDecimal> REFUND_BEFORE_SETTLE = new TypedField<>(BigDecimal.class, "refundBeforeSettle");
        TypedField<BigDecimal> PLATFORM_COUPON = new TypedField<>(BigDecimal.class, "platformCoupon");
        TypedField<BigDecimal> AUTHOR_COUPON = new TypedField<>(BigDecimal.class, "authorCoupon");
        TypedField<BigDecimal> ZT_PAY_PROMOTION = new TypedField<>(BigDecimal.class, "ztPayPromotion");
        TypedField<BigDecimal> ZR_PAY_PROMOTION = new TypedField<>(BigDecimal.class, "zrPayPromotion");
        TypedField<BigDecimal> REAL_PAY_AMOUNT = new TypedField<>(BigDecimal.class, "realPayAmount");
        TypedField<BigDecimal> TOTAL_INCOME = new TypedField<>(BigDecimal.class, "totalIncome");
        TypedField<BigDecimal> PLATFORM_SERVICE_FEE = new TypedField<>(BigDecimal.class, "platformServiceFee");
        TypedField<BigDecimal> COMMISSION = new TypedField<>(BigDecimal.class, "commission");
        TypedField<BigDecimal> GOOD_LEARN_CHANNEL_FEE = new TypedField<>(BigDecimal.class, "goodLearnChannelFee");
        TypedField<BigDecimal> COLONEL_SERVICE_FEE = new TypedField<>(BigDecimal.class, "colonelServiceFee");
        TypedField<BigDecimal> CHANNEL_PROMOTION_FEE = new TypedField<>(BigDecimal.class, "channelPromotionFee");
        TypedField<BigDecimal> OTHER_SHARING_AMOUNT = new TypedField<>(BigDecimal.class, "otherSharingAmount");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<LocalDateTime> SETTLE_TIME = new TypedField<>(LocalDateTime.class, "settleTime");
        TypedField<LocalDateTime> ORDER_TIME = new TypedField<>(LocalDateTime.class, "orderTime");
        TypedField<String> DATA_ORIG = new TypedField<>(String.class, "dataOrig");
        TypedField<BigDecimal> TOTAL_AUTCOME = new TypedField<>(BigDecimal.class, "totalAutcome");
        TypedField<String> SETTLE_POOL_NO = new TypedField<>(String.class, "settlePoolNo");
    }
    public interface OrderPool {
        static Long id() {
            return 1524011868307259393L;
        }
        static String code() {
            return "orderPool";
        }
        TypedField<String> APPLY_NO = new TypedField<>(String.class, "applyNo");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> STORE_ID = new TypedField<>(String.class, "storeId");
        TypedField<String> MAIN_ORDER_NO = new TypedField<>(String.class, "mainOrderNo");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaserBankAccount");
        TypedField<String> APPLY_TYPE = new TypedField<>(String.class, "applyType");
        TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "applyTime");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlementStatus");
        TypedField<String> MAKE_INVOICE_STATUS = new TypedField<>(String.class, "makeInvoiceStatus");
        TypedField<String> SUBMIT_INVOICE_STATUS = new TypedField<>(String.class, "submitInvoiceStatus");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> HEADER_TYPE = new TypedField<>(String.class, "headerType");
        TypedField<BigDecimal> ORDER_TOTAL = new TypedField<>(BigDecimal.class, "orderTotal");
        TypedField<BigDecimal> GOODS_TOTAL = new TypedField<>(BigDecimal.class, "goodsTotal");
        TypedField<String> DATA_ORIG = new TypedField<>(String.class, "dataOrig");
        TypedField<BigDecimal> SETTLEMENT_TOTAL = new TypedField<>(BigDecimal.class, "settlementTotal");
        TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceAmount");
        TypedField<String> IS_CONSISTENT = new TypedField<>(String.class, "isConsistent");
        TypedField<BigDecimal> VERIFICATION_VARIANCE = new TypedField<>(BigDecimal.class, "verificationVariance");
        TypedField<LocalDateTime> CANCEL_TIME = new TypedField<>(LocalDateTime.class, "cancelTime");
        TypedField<String> CANCEL_REASON = new TypedField<>(String.class, "cancelReason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "expressNumber");
        TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoiceOrig");
        TypedField<String> FORCE_INVOICE = new TypedField<>(String.class, "forceInvoice");
        TypedField<LocalDateTime> MAKE_INVOICE_TIME = new TypedField<>(LocalDateTime.class, "makeInvoiceTime");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> STORE_NAME = new TypedField<>(String.class, "storeName");
        TypedField<BigDecimal> ASSESSMENT_COUNT_DOWN = new TypedField<>(BigDecimal.class, "assessmentCountDown");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface OrderPoolRaw {
        static Long id() {
            return 1532257726018170882L;
        }
        static String code() {
            return "orderPoolRaw";
        }
        TypedField<String> APPLY_NO = new TypedField<>(String.class, "applyNo");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> STORE_ID = new TypedField<>(String.class, "storeId");
        TypedField<String> MAIN_ORDER_NO = new TypedField<>(String.class, "mainOrderNo");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaserBankAccount");
        TypedField<String> APPLY_TYPE = new TypedField<>(String.class, "applyType");
        TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "applyTime");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlementStatus");
        TypedField<String> MAKE_INVOICE_STATUS = new TypedField<>(String.class, "makeInvoiceStatus");
        TypedField<String> SUBMIT_INVOICE_STATUS = new TypedField<>(String.class, "submitInvoiceStatus");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> HEADER_TYPE = new TypedField<>(String.class, "headerType");
        TypedField<BigDecimal> ORDER_TOTAL = new TypedField<>(BigDecimal.class, "orderTotal");
        TypedField<BigDecimal> GOODS_TOTAL = new TypedField<>(BigDecimal.class, "goodsTotal");
        TypedField<String> DATA_ORIG = new TypedField<>(String.class, "dataOrig");
        TypedField<BigDecimal> SETTLEMENT_TOTAL = new TypedField<>(BigDecimal.class, "settlementTotal");
        TypedField<BigDecimal> INVOICE_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceAmount");
        TypedField<String> IS_CONSISTENT = new TypedField<>(String.class, "isConsistent");
        TypedField<BigDecimal> VERIFICATION_VARIANCE = new TypedField<>(BigDecimal.class, "verificationVariance");
        TypedField<LocalDateTime> CANCEL_TIME = new TypedField<>(LocalDateTime.class, "cancelTime");
        TypedField<String> CANCEL_REASON = new TypedField<>(String.class, "cancelReason");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "expressNumber");
        TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoiceOrig");
        TypedField<String> FORCE_INVOICE = new TypedField<>(String.class, "forceInvoice");
        TypedField<LocalDateTime> MAKE_INVOICE_TIME = new TypedField<>(LocalDateTime.class, "makeInvoiceTime");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> STORE_NAME = new TypedField<>(String.class, "storeName");
        TypedField<String> INVOICE_DETAILS = new TypedField<>(String.class, "invoiceDetails");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> ASSESSMENT_COUNT_DOWN = new TypedField<>(BigDecimal.class, "assessmentCountDown");
    }
    public interface BlobFiles {
        static Long id() {
            return 1622879518611537921L;
        }
        static String code() {
            return "blobFiles";
        }
        TypedField<String> FILE_NAME = new TypedField<>(String.class, "fileName");
        TypedField<String> FILE_STATUS = new TypedField<>(String.class, "fileStatus");
        TypedField<String> FILE_TYPE = new TypedField<>(String.class, "fileType");
        TypedField<String> FILE_FORMAT = new TypedField<>(String.class, "fileFormat");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<String> FILE_DIRECTORY = new TypedField<>(String.class, "fileDirectory");
        TypedField<String> FILE_ARCHIVE_DIRECTORY = new TypedField<>(String.class, "fileArchiveDirectory");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "errorReasonEnum");
        TypedField<Long> PROCESS_INDEX = new TypedField<>(Long.class, "processIndex");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface BillingHead {
        static Long id() {
            return 1626470366621282305L;
        }
        static String code() {
            return "billingHead";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLINGDOCUMENT = new TypedField<>(String.class, "billingdocument");
        TypedField<String> COMPANYCODE = new TypedField<>(String.class, "companycode");
        TypedField<String> SALESORGANIZATION = new TypedField<>(String.class, "salesorganization");
        TypedField<String> PAYER = new TypedField<>(String.class, "payer");
        TypedField<String> NAMEOFPAYER = new TypedField<>(String.class, "nameofpayer");
        TypedField<String> SOLDTOPARTY = new TypedField<>(String.class, "soldtoparty");
        TypedField<String> NAMEOFSOLDTOPARTY = new TypedField<>(String.class, "nameofsoldtoparty");
        TypedField<String> KEYCUSTOMER4NAME = new TypedField<>(String.class, "keycustomer4name");
        TypedField<String> REFERENCEDOCUMENTN = new TypedField<>(String.class, "referencedocumentn");
        TypedField<String> BILLINGDATE = new TypedField<>(String.class, "billingdate");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingtype");
        TypedField<String> NETVALUE = new TypedField<>(String.class, "netvalue");
        TypedField<String> TAXAMOUNT = new TypedField<>(String.class, "taxamount");
        TypedField<String> PONUMBER = new TypedField<>(String.class, "ponumber");
        TypedField<String> REDIVNOTICENO = new TypedField<>(String.class, "redivnoticeno");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "errorReasonEnum");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<LocalDateTime> RETRY_TIME = new TypedField<>(LocalDateTime.class, "retryTime");
        TypedField<String> P_BILLING_TYPE = new TypedField<>(String.class, "pBillingType");
        TypedField<String> P_WRITE_OFF_TYPE = new TypedField<>(String.class, "pWriteOffType");
        TypedField<String> P_WRITE_OFF_BILLING_NO = new TypedField<>(String.class, "pWriteOffBillingNo");
        /**
         * 对一关联关系 关联对象 blobFiles
         */
        TypedField<Long> BLOB_FILES_BILLING_HEAD_ID = new TypedField<>(Long.class, "blobFilesBillingHead.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BLOB_FILES_BILLING_HEAD {
                static String code () {
                    return "blobFilesBillingHead" ;
                }
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "blobFilesBillingHead.fileName");
                TypedField<String> FILE_STATUS = new TypedField<>(String.class, "blobFilesBillingHead.fileStatus");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "blobFilesBillingHead.fileType");
                TypedField<String> FILE_FORMAT = new TypedField<>(String.class, "blobFilesBillingHead.fileFormat");
                TypedField<Long> ID = new TypedField<>(Long.class, "blobFilesBillingHead.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "blobFilesBillingHead.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "blobFilesBillingHead.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "blobFilesBillingHead.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "blobFilesBillingHead.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "blobFilesBillingHead.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "blobFilesBillingHead.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "blobFilesBillingHead.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "blobFilesBillingHead.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "blobFilesBillingHead.delete_flag");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "blobFilesBillingHead.retryCount");
                TypedField<String> FILE_DIRECTORY = new TypedField<>(String.class, "blobFilesBillingHead.fileDirectory");
                TypedField<String> FILE_ARCHIVE_DIRECTORY = new TypedField<>(String.class, "blobFilesBillingHead.fileArchiveDirectory");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "blobFilesBillingHead.errorInfo");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "blobFilesBillingHead.errorReasonEnum");
                TypedField<Long> PROCESS_INDEX = new TypedField<>(Long.class, "blobFilesBillingHead.processIndex");
            }
        }
    }
    public interface BillingDetails {
        static Long id() {
            return 1626476114292101121L;
        }
        static String code() {
            return "billingDetails";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLINGDOCUMENT = new TypedField<>(String.class, "billingdocument");
        TypedField<String> BILLINGITEM = new TypedField<>(String.class, "billingitem");
        TypedField<String> COMPANYCODE = new TypedField<>(String.class, "companycode");
        TypedField<String> SALESORGANIZATION = new TypedField<>(String.class, "salesorganization");
        TypedField<String> BILLTOPARTY = new TypedField<>(String.class, "billtoparty");
        TypedField<String> NAMEOFBILLTOPART = new TypedField<>(String.class, "nameofbilltopart");
        TypedField<String> LOCALSALESWORKFORCEL4 = new TypedField<>(String.class, "localsalesworkforcel4");
        TypedField<String> EMSCODE = new TypedField<>(String.class, "emscode");
        TypedField<String> KEYCUSTOMER4NAME = new TypedField<>(String.class, "keycustomer4name");
        TypedField<String> REFERENCEOBD = new TypedField<>(String.class, "referenceobd");
        TypedField<String> BILLINGDATE = new TypedField<>(String.class, "billingdate");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingtype");
        TypedField<String> PONUMBER = new TypedField<>(String.class, "ponumber");
        TypedField<String> SALESDOC = new TypedField<>(String.class, "salesdoc");
        TypedField<String> MATNUMUSEDCUSTOMER = new TypedField<>(String.class, "matnumusedcustomer");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> NETVALUE = new TypedField<>(String.class, "netvalue");
        TypedField<String> TAX = new TypedField<>(String.class, "tax");
        TypedField<String> NETVALUETAX = new TypedField<>(String.class, "netvaluetax");
        TypedField<String> ORIGINALBOXPRICE = new TypedField<>(String.class, "originalboxprice");
        TypedField<String> PUBLISHPRICE = new TypedField<>(String.class, "publishprice");
        TypedField<String> SALESDEAL = new TypedField<>(String.class, "salesdeal");
        TypedField<String> EXTERNALDESCRIPTION = new TypedField<>(String.class, "externaldescription");
        TypedField<String> OTDISCOUNT = new TypedField<>(String.class, "otdiscount");
        TypedField<String> EOTDISCOUNT = new TypedField<>(String.class, "eotdiscount");
        TypedField<String> CPPDISCOUNT = new TypedField<>(String.class, "cppdiscount");
        TypedField<String> AFTEREOTOT = new TypedField<>(String.class, "aftereotot");
        TypedField<String> INTERNALORDER = new TypedField<>(String.class, "internalorder");
        TypedField<String> MATERIAL = new TypedField<>(String.class, "material");
        TypedField<String> MATERIALDESCRIPTION = new TypedField<>(String.class, "materialdescription");
        TypedField<String> INVOICEDQTY = new TypedField<>(String.class, "invoicedqty");
        TypedField<String> SALESUNIT = new TypedField<>(String.class, "salesunit");
        TypedField<String> PLANT = new TypedField<>(String.class, "plant");
        TypedField<String> VATREGISTRATIONNO = new TypedField<>(String.class, "vatregistrationno");
        TypedField<String> TAXRATE = new TypedField<>(String.class, "taxrate");
        TypedField<String> NETPRICE1 = new TypedField<>(String.class, "netprice1");
        TypedField<String> NETPRICE2 = new TypedField<>(String.class, "netprice2");
        TypedField<String> DISCOUNT = new TypedField<>(String.class, "discount");
        TypedField<String> NETINVOICE = new TypedField<>(String.class, "netinvoice");
        TypedField<String> NOTES = new TypedField<>(String.class, "notes");
        TypedField<String> COMMODITYCODE = new TypedField<>(String.class, "commoditycode");
        TypedField<String> CUSTOMERTELNO = new TypedField<>(String.class, "customertelno");
        TypedField<String> CUSTOMERADDRESS = new TypedField<>(String.class, "customeraddress");
        TypedField<String> BANKNAME = new TypedField<>(String.class, "bankname");
        TypedField<String> BANKACCOUNTNO = new TypedField<>(String.class, "bankaccountno");
        TypedField<String> STATUSFORTRANSFER = new TypedField<>(String.class, "statusfortransfer");
        TypedField<String> GTXINVOICECODE = new TypedField<>(String.class, "gtxinvoicecode");
        TypedField<String> GOLDENTAXISSUEDATE = new TypedField<>(String.class, "goldentaxissuedate");
        /**
         * 对一关联关系 关联对象 billingHead
         */
        TypedField<Long> BILLING_DETAILS_MANY_ID = new TypedField<>(Long.class, "billingDetailsMany.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILLING_DETAILS_MANY {
                static String code () {
                    return "billingDetailsMany" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "billingDetailsMany.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billingDetailsMany.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billingDetailsMany.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billingDetailsMany.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billingDetailsMany.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billingDetailsMany.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billingDetailsMany.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billingDetailsMany.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billingDetailsMany.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billingDetailsMany.delete_flag");
                TypedField<String> BILLINGDOCUMENT = new TypedField<>(String.class, "billingDetailsMany.billingdocument");
                TypedField<String> COMPANYCODE = new TypedField<>(String.class, "billingDetailsMany.companycode");
                TypedField<String> SALESORGANIZATION = new TypedField<>(String.class, "billingDetailsMany.salesorganization");
                TypedField<String> PAYER = new TypedField<>(String.class, "billingDetailsMany.payer");
                TypedField<String> NAMEOFPAYER = new TypedField<>(String.class, "billingDetailsMany.nameofpayer");
                TypedField<String> SOLDTOPARTY = new TypedField<>(String.class, "billingDetailsMany.soldtoparty");
                TypedField<String> NAMEOFSOLDTOPARTY = new TypedField<>(String.class, "billingDetailsMany.nameofsoldtoparty");
                TypedField<String> KEYCUSTOMER4NAME = new TypedField<>(String.class, "billingDetailsMany.keycustomer4name");
                TypedField<String> REFERENCEDOCUMENTN = new TypedField<>(String.class, "billingDetailsMany.referencedocumentn");
                TypedField<String> BILLINGDATE = new TypedField<>(String.class, "billingDetailsMany.billingdate");
                TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingDetailsMany.billingtype");
                TypedField<String> NETVALUE = new TypedField<>(String.class, "billingDetailsMany.netvalue");
                TypedField<String> TAXAMOUNT = new TypedField<>(String.class, "billingDetailsMany.taxamount");
                TypedField<String> PONUMBER = new TypedField<>(String.class, "billingDetailsMany.ponumber");
                TypedField<String> REDIVNOTICENO = new TypedField<>(String.class, "billingDetailsMany.redivnoticeno");
                TypedField<String> STATUS = new TypedField<>(String.class, "billingDetailsMany.status");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "billingDetailsMany.errorReasonEnum");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "billingDetailsMany.errorInfo");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "billingDetailsMany.retryCount");
                TypedField<LocalDateTime> RETRY_TIME = new TypedField<>(LocalDateTime.class, "billingDetailsMany.retryTime");
                TypedField<String> P_BILLING_TYPE = new TypedField<>(String.class, "billingDetailsMany.pBillingType");
                TypedField<String> P_WRITE_OFF_TYPE = new TypedField<>(String.class, "billingDetailsMany.pWriteOffType");
                TypedField<String> P_WRITE_OFF_BILLING_NO = new TypedField<>(String.class, "billingDetailsMany.pWriteOffBillingNo");
            }
        }
    }
    public interface BillingDiscountDetails {
        static Long id() {
            return 1626481221052215298L;
        }
        static String code() {
            return "billingDiscountDetails";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLINGDOC = new TypedField<>(String.class, "billingdoc");
        TypedField<String> BILLINGITEM = new TypedField<>(String.class, "billingitem");
        TypedField<String> CONDITIONTYPE = new TypedField<>(String.class, "conditiontype");
        TypedField<String> CONDITIONUNIT = new TypedField<>(String.class, "conditionunit");
        TypedField<String> CONDITIONVALUE = new TypedField<>(String.class, "conditionvalue");
        /**
         * 对一关联关系 关联对象 billingDetails
         */
        TypedField<Long> BILLING_DISCOUNT_DETAILS_ID = new TypedField<>(Long.class, "billingDiscountDetails.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILLING_DISCOUNT_DETAILS {
                static String code () {
                    return "billingDiscountDetails" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "billingDiscountDetails.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billingDiscountDetails.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billingDiscountDetails.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billingDiscountDetails.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billingDiscountDetails.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billingDiscountDetails.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billingDiscountDetails.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billingDiscountDetails.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billingDiscountDetails.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billingDiscountDetails.delete_flag");
                TypedField<String> BILLINGDOCUMENT = new TypedField<>(String.class, "billingDiscountDetails.billingdocument");
                TypedField<String> BILLINGITEM = new TypedField<>(String.class, "billingDiscountDetails.billingitem");
                TypedField<String> COMPANYCODE = new TypedField<>(String.class, "billingDiscountDetails.companycode");
                TypedField<String> SALESORGANIZATION = new TypedField<>(String.class, "billingDiscountDetails.salesorganization");
                TypedField<String> BILLTOPARTY = new TypedField<>(String.class, "billingDiscountDetails.billtoparty");
                TypedField<String> NAMEOFBILLTOPART = new TypedField<>(String.class, "billingDiscountDetails.nameofbilltopart");
                TypedField<String> LOCALSALESWORKFORCEL4 = new TypedField<>(String.class, "billingDiscountDetails.localsalesworkforcel4");
                TypedField<String> EMSCODE = new TypedField<>(String.class, "billingDiscountDetails.emscode");
                TypedField<String> KEYCUSTOMER4NAME = new TypedField<>(String.class, "billingDiscountDetails.keycustomer4name");
                TypedField<String> REFERENCEOBD = new TypedField<>(String.class, "billingDiscountDetails.referenceobd");
                TypedField<String> BILLINGDATE = new TypedField<>(String.class, "billingDiscountDetails.billingdate");
                TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingDiscountDetails.billingtype");
                TypedField<String> PONUMBER = new TypedField<>(String.class, "billingDiscountDetails.ponumber");
                TypedField<String> SALESDOC = new TypedField<>(String.class, "billingDiscountDetails.salesdoc");
                TypedField<String> MATNUMUSEDCUSTOMER = new TypedField<>(String.class, "billingDiscountDetails.matnumusedcustomer");
                TypedField<String> STATUS = new TypedField<>(String.class, "billingDiscountDetails.status");
                TypedField<String> NETVALUE = new TypedField<>(String.class, "billingDiscountDetails.netvalue");
                TypedField<String> TAX = new TypedField<>(String.class, "billingDiscountDetails.tax");
                TypedField<String> NETVALUETAX = new TypedField<>(String.class, "billingDiscountDetails.netvaluetax");
                TypedField<String> ORIGINALBOXPRICE = new TypedField<>(String.class, "billingDiscountDetails.originalboxprice");
                TypedField<String> PUBLISHPRICE = new TypedField<>(String.class, "billingDiscountDetails.publishprice");
                TypedField<String> SALESDEAL = new TypedField<>(String.class, "billingDiscountDetails.salesdeal");
                TypedField<String> EXTERNALDESCRIPTION = new TypedField<>(String.class, "billingDiscountDetails.externaldescription");
                TypedField<String> OTDISCOUNT = new TypedField<>(String.class, "billingDiscountDetails.otdiscount");
                TypedField<String> EOTDISCOUNT = new TypedField<>(String.class, "billingDiscountDetails.eotdiscount");
                TypedField<String> CPPDISCOUNT = new TypedField<>(String.class, "billingDiscountDetails.cppdiscount");
                TypedField<String> AFTEREOTOT = new TypedField<>(String.class, "billingDiscountDetails.aftereotot");
                TypedField<String> INTERNALORDER = new TypedField<>(String.class, "billingDiscountDetails.internalorder");
                TypedField<String> MATERIAL = new TypedField<>(String.class, "billingDiscountDetails.material");
                TypedField<String> MATERIALDESCRIPTION = new TypedField<>(String.class, "billingDiscountDetails.materialdescription");
                TypedField<String> INVOICEDQTY = new TypedField<>(String.class, "billingDiscountDetails.invoicedqty");
                TypedField<String> SALESUNIT = new TypedField<>(String.class, "billingDiscountDetails.salesunit");
                TypedField<String> PLANT = new TypedField<>(String.class, "billingDiscountDetails.plant");
                TypedField<String> VATREGISTRATIONNO = new TypedField<>(String.class, "billingDiscountDetails.vatregistrationno");
                TypedField<String> TAXRATE = new TypedField<>(String.class, "billingDiscountDetails.taxrate");
                TypedField<String> NETPRICE1 = new TypedField<>(String.class, "billingDiscountDetails.netprice1");
                TypedField<String> NETPRICE2 = new TypedField<>(String.class, "billingDiscountDetails.netprice2");
                TypedField<String> DISCOUNT = new TypedField<>(String.class, "billingDiscountDetails.discount");
                TypedField<String> NETINVOICE = new TypedField<>(String.class, "billingDiscountDetails.netinvoice");
                TypedField<String> NOTES = new TypedField<>(String.class, "billingDiscountDetails.notes");
                TypedField<String> COMMODITYCODE = new TypedField<>(String.class, "billingDiscountDetails.commoditycode");
                TypedField<String> CUSTOMERTELNO = new TypedField<>(String.class, "billingDiscountDetails.customertelno");
                TypedField<String> CUSTOMERADDRESS = new TypedField<>(String.class, "billingDiscountDetails.customeraddress");
                TypedField<String> BANKNAME = new TypedField<>(String.class, "billingDiscountDetails.bankname");
                TypedField<String> BANKACCOUNTNO = new TypedField<>(String.class, "billingDiscountDetails.bankaccountno");
                TypedField<String> STATUSFORTRANSFER = new TypedField<>(String.class, "billingDiscountDetails.statusfortransfer");
                TypedField<String> GTXINVOICECODE = new TypedField<>(String.class, "billingDiscountDetails.gtxinvoicecode");
                TypedField<String> GOLDENTAXISSUEDATE = new TypedField<>(String.class, "billingDiscountDetails.goldentaxissuedate");
            }
        }
    }
    public interface Producer {
        static Long id() {
            return 1628644901645291522L;
        }
        static String code() {
            return "producer";
        }
        TypedField<String> PRODUCE_OBJ = new TypedField<>(String.class, "produceObj");
        TypedField<String> PRODUCE_STATUS = new TypedField<>(String.class, "produceStatus");
        TypedField<String> PRODUCE_TYPE = new TypedField<>(String.class, "produceType");
        TypedField<String> PRODUCE_SOURCE = new TypedField<>(String.class, "produceSource");
        TypedField<String> PRODUCE_MESSAGE = new TypedField<>(String.class, "produceMessage");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "businessKey");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface Customer {
        static Long id() {
            return 1628649067878363138L;
        }
        static String code() {
            return "customer";
        }
        TypedField<String> CUSTOMER_MESSAGE = new TypedField<>(String.class, "customerMessage");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<String> CUSTOMER_OBJ = new TypedField<>(String.class, "customerObj");
        TypedField<String> CUSTOMER_STATUS = new TypedField<>(String.class, "customerStatus");
        TypedField<String> CUSTOMER_TYPE = new TypedField<>(String.class, "customerType");
        TypedField<String> CUSTOMER_SOURCE = new TypedField<>(String.class, "customerSource");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "businessKey");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<LocalDateTime> RETRY_TIME = new TypedField<>(LocalDateTime.class, "retryTime");
        TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "errorReasonEnum");
        /**
         * 对一关联关系 关联对象 producer
         */
        TypedField<Long> PRODUCER_TO_MANY_CONSUMER_ID = new TypedField<>(Long.class, "producerToManyConsumer.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PRODUCER_TO_MANY_CONSUMER {
                static String code () {
                    return "producerToManyConsumer" ;
                }
                TypedField<String> PRODUCE_OBJ = new TypedField<>(String.class, "producerToManyConsumer.produceObj");
                TypedField<String> PRODUCE_STATUS = new TypedField<>(String.class, "producerToManyConsumer.produceStatus");
                TypedField<String> PRODUCE_TYPE = new TypedField<>(String.class, "producerToManyConsumer.produceType");
                TypedField<String> PRODUCE_SOURCE = new TypedField<>(String.class, "producerToManyConsumer.produceSource");
                TypedField<String> PRODUCE_MESSAGE = new TypedField<>(String.class, "producerToManyConsumer.produceMessage");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "producerToManyConsumer.serialNo");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "producerToManyConsumer.businessKey");
                TypedField<Long> ID = new TypedField<>(Long.class, "producerToManyConsumer.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "producerToManyConsumer.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "producerToManyConsumer.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "producerToManyConsumer.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "producerToManyConsumer.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "producerToManyConsumer.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "producerToManyConsumer.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "producerToManyConsumer.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "producerToManyConsumer.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "producerToManyConsumer.delete_flag");
            }
        }
    }
    public interface DispatcherRuleConfig {
        static Long id() {
            return 1628660079054630913L;
        }
        static String code() {
            return "dispatcherRuleConfig";
        }
        TypedField<String> PRODUCE_OBJ = new TypedField<>(String.class, "produceObj");
        TypedField<String> PRODUCE_TYPE = new TypedField<>(String.class, "produceType");
        TypedField<String> PRODUCE_SOURCE = new TypedField<>(String.class, "produceSource");
        TypedField<Boolean> IS_OPEN = new TypedField<>(Boolean.class, "isOpen");
        TypedField<String> CONSUMER_OBJ = new TypedField<>(String.class, "consumerObj");
        TypedField<String> CONSUMER_TYPE = new TypedField<>(String.class, "consumerType");
        TypedField<String> CONSUMER_SOURCE = new TypedField<>(String.class, "consumerSource");
        TypedField<String> NEXT_RETRY_TIME = new TypedField<>(String.class, "nextRetryTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface BusinessUnitConfig {
        static Long id() {
            return 1629018799925628929L;
        }
        static String code() {
            return "businessUnitConfig";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> SALES_ORG = new TypedField<>(String.class, "salesOrg");
    }
    public interface DiscountReasonConfig {
        static Long id() {
            return 1629030844586790914L;
        }
        static String code() {
            return "discountReasonConfig";
        }
        TypedField<String> DISCOUNT_NAME = new TypedField<>(String.class, "discountName");
        TypedField<String> DISCOUNT_DESCRIPTION = new TypedField<>(String.class, "discountDescription");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> DISCOUNT_TYPE = new TypedField<>(String.class, "discountType");
    }
    public interface NoInvoicedReasonConfig {
        static Long id() {
            return 1629037919673634818L;
        }
        static String code() {
            return "noInvoicedReasonConfig";
        }
        TypedField<String> CUSTOMER_CODE = new TypedField<>(String.class, "customerCode");
        TypedField<String> NO_INVOICE_STATUS = new TypedField<>(String.class, "noInvoiceStatus");
        TypedField<String> NO_INVOICE_REASON_DESC = new TypedField<>(String.class, "noInvoiceReasonDesc");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> NO_INVOICE_REASON = new TypedField<>(String.class, "noInvoiceReason");
    }
    public interface MdmInit {
        static Long id() {
            return 1630134641055313921L;
        }
        static String code() {
            return "mdmInit";
        }
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CUST_CODE = new TypedField<>(String.class, "custCode");
        TypedField<String> SALE_ORG_CODE = new TypedField<>(String.class, "saleOrgCode");
        TypedField<String> PARTNER_FUNC = new TypedField<>(String.class, "partnerFunc");
        TypedField<String> CUST_ADDR = new TypedField<>(String.class, "custAddr");
        TypedField<String> TO_CODE = new TypedField<>(String.class, "toCode");
        TypedField<String> TO_NAME = new TypedField<>(String.class, "toName");
        TypedField<String> TREE1_LEVEL4_NAME = new TypedField<>(String.class, "tree1Level4Name");
        TypedField<String> TO_IS_DEFAULT = new TypedField<>(String.class, "toIsDefault");
        TypedField<String> DOC_NUM = new TypedField<>(String.class, "docNum");
        TypedField<String> BANK_CODE = new TypedField<>(String.class, "bankCode");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT_NO = new TypedField<>(String.class, "bankAccountNo");
        TypedField<String> BANK_ACCOUNT_TYPE = new TypedField<>(String.class, "bankAccountType");
        TypedField<String> PHONE = new TypedField<>(String.class, "phone");
        TypedField<String> VAT_REGISTRATION_NO = new TypedField<>(String.class, "vatRegistrationNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> BILLING_MAIL = new TypedField<>(String.class, "billingMail");
        TypedField<String> GUI_CODE = new TypedField<>(String.class, "guiCode");
        TypedField<String> OPERATION_TYPE = new TypedField<>(String.class, "operationType");
        TypedField<String> COMBINATION_REFERENCE = new TypedField<>(String.class, "combinationReference");
        TypedField<String> DT = new TypedField<>(String.class, "dt");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IS_ELECTRONIC = new TypedField<>(String.class, "isElectronic");
        TypedField<String> IS_DISCOUNT_DETAILS = new TypedField<>(String.class, "isDiscountDetails");
        /**
         * 对一关联关系 关联对象 mdmSync
         */
        TypedField<Long> INIT_RELATION_ID = new TypedField<>(Long.class, "initRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INIT_RELATION {
                static String code () {
                    return "initRelation" ;
                }
                TypedField<String> STATUS = new TypedField<>(String.class, "initRelation.status");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "initRelation.retryCount");
                TypedField<String> LAST_FAULT_REASON = new TypedField<>(String.class, "initRelation.lastFaultReason");
                TypedField<String> REMARK = new TypedField<>(String.class, "initRelation.remark");
                TypedField<LocalDateTime> QUERY_DATE = new TypedField<>(LocalDateTime.class, "initRelation.queryDate");
                TypedField<Long> LAST_QUERY_PAGE = new TypedField<>(Long.class, "initRelation.lastQueryPage");
                TypedField<Long> ID = new TypedField<>(Long.class, "initRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "initRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "initRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "initRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "initRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "initRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "initRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "initRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "initRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "initRelation.delete_flag");
                TypedField<Long> TOTAL_COUNT = new TypedField<>(Long.class, "initRelation.totalCount");
                TypedField<Long> PAGE_COUNT = new TypedField<>(Long.class, "initRelation.pageCount");
                TypedField<Long> PAGE_SIZE = new TypedField<>(Long.class, "initRelation.pageSize");
                TypedField<Long> PULL_TOTAL = new TypedField<>(Long.class, "initRelation.pullTotal");
            }
        }
    }
    public interface OpenARInit {
        static Long id() {
            return 1630135554657062914L;
        }
        static String code() {
            return "openARInit";
        }
        TypedField<String> OPEN_A_R_INIT = new TypedField<>(String.class, "openARInit");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface StatementInit {
        static Long id() {
            return 1630135655826722817L;
        }
        static String code() {
            return "statementInit";
        }
        TypedField<String> STATEMENT_INIT = new TypedField<>(String.class, "statementInit");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface InvoiceMatchInit {
        static Long id() {
            return 1630135747284668418L;
        }
        static String code() {
            return "invoiceMatchInit";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLING_DOCUMENT = new TypedField<>(String.class, "billingDocument");
        TypedField<String> USER_NAME = new TypedField<>(String.class, "userName");
        TypedField<String> GL_ACCOUNT = new TypedField<>(String.class, "glAccount");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> ASSIGNMENT = new TypedField<>(String.class, "assignment");
        TypedField<String> INVOICE_REFERENCE = new TypedField<>(String.class, "invoiceReference");
        TypedField<String> REFERENCE = new TypedField<>(String.class, "reference");
        TypedField<String> DOCUMENT_NUMBER = new TypedField<>(String.class, "documentNumber");
        TypedField<String> DOCUMENT_DATE = new TypedField<>(String.class, "documentDate");
        TypedField<String> POSTING_DATE = new TypedField<>(String.class, "postingDate");
        TypedField<String> TIME_OF_ENTRY = new TypedField<>(String.class, "timeOfEntry");
        TypedField<String> NET_DUE_DATE = new TypedField<>(String.class, "netDueDate");
        TypedField<String> PAYMENT_METHOD = new TypedField<>(String.class, "paymentMethod");
        TypedField<String> AMOUNT_IN_LOCAL_CURRENCY = new TypedField<>(String.class, "amountInLocalCurrency");
        TypedField<String> TEXT = new TypedField<>(String.class, "text");
        TypedField<String> DOCUMENT_HEADER_TEXT = new TypedField<>(String.class, "documentHeaderText");
        TypedField<String> FLOW_TYPE = new TypedField<>(String.class, "flowType");
        TypedField<String> SP_G_L_TRANS_TYPE = new TypedField<>(String.class, "spGLTransType");
        TypedField<String> DOCUMENT_TYPE = new TypedField<>(String.class, "documentType");
        TypedField<String> SPECIAL_G_L_IND = new TypedField<>(String.class, "specialGLInd");
        TypedField<String> ARREARS_AFTER_NET_DUE_DATE = new TypedField<>(String.class, "arrearsAfterNetDueDate");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> POSTING_KEY = new TypedField<>(String.class, "postingKey");
        TypedField<String> CLEARING_DOCUMENT = new TypedField<>(String.class, "clearingDocument");
        TypedField<String> BRANCH_ACCOUNT = new TypedField<>(String.class, "branchAccount");
        TypedField<String> REFERENCE_KEY3 = new TypedField<>(String.class, "referenceKey3");
        TypedField<String> PAYMENT_REFERENCE = new TypedField<>(String.class, "paymentReference");
        /**
         * 对一关联关系 关联对象 blobFiles
         */
        TypedField<Long> BLOB_FILES_INVOICE_MATCH_ID = new TypedField<>(Long.class, "blobFilesInvoiceMatch.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BLOB_FILES_INVOICE_MATCH {
                static String code () {
                    return "blobFilesInvoiceMatch" ;
                }
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "blobFilesInvoiceMatch.fileName");
                TypedField<String> FILE_STATUS = new TypedField<>(String.class, "blobFilesInvoiceMatch.fileStatus");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "blobFilesInvoiceMatch.fileType");
                TypedField<String> FILE_FORMAT = new TypedField<>(String.class, "blobFilesInvoiceMatch.fileFormat");
                TypedField<Long> ID = new TypedField<>(Long.class, "blobFilesInvoiceMatch.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "blobFilesInvoiceMatch.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "blobFilesInvoiceMatch.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "blobFilesInvoiceMatch.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "blobFilesInvoiceMatch.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "blobFilesInvoiceMatch.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "blobFilesInvoiceMatch.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "blobFilesInvoiceMatch.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "blobFilesInvoiceMatch.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "blobFilesInvoiceMatch.delete_flag");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "blobFilesInvoiceMatch.retryCount");
                TypedField<String> FILE_DIRECTORY = new TypedField<>(String.class, "blobFilesInvoiceMatch.fileDirectory");
                TypedField<String> FILE_ARCHIVE_DIRECTORY = new TypedField<>(String.class, "blobFilesInvoiceMatch.fileArchiveDirectory");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "blobFilesInvoiceMatch.errorInfo");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "blobFilesInvoiceMatch.errorReasonEnum");
                TypedField<Long> PROCESS_INDEX = new TypedField<>(Long.class, "blobFilesInvoiceMatch.processIndex");
            }
        }
    }
    public interface Mdm {
        static Long id() {
            return 1630141623089336322L;
        }
        static String code() {
            return "mdm";
        }
        TypedField<String> CUST_CODE = new TypedField<>(String.class, "custCode");
        TypedField<String> SALE_ORG_CODE = new TypedField<>(String.class, "saleOrgCode");
        TypedField<String> TREE1_LEVEL4_NAME = new TypedField<>(String.class, "tree1Level4Name");
        TypedField<String> TO_CODE = new TypedField<>(String.class, "toCode");
        TypedField<String> TO_NAME = new TypedField<>(String.class, "toName");
        TypedField<String> IS_ELECTRONIC = new TypedField<>(String.class, "isElectronic");
        TypedField<String> IS_DISCOUNT_DETAILS = new TypedField<>(String.class, "isDiscountDetails");
        TypedField<String> CUSTOMER_TYPE = new TypedField<>(String.class, "customerType");
        TypedField<String> IS_ACCOUNT_CHECK = new TypedField<>(String.class, "isAccountCheck");
        TypedField<String> RETAILER_CODE = new TypedField<>(String.class, "retailerCode");
        TypedField<String> RETAILER_NAME = new TypedField<>(String.class, "retailerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> PARTNERS = new TypedField<>(String.class, "partners");
        TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "isDefault");
        TypedField<String> PARTNER_FUC = new TypedField<>(String.class, "partnerFuc");
    }
    public interface MdmSync {
        static Long id() {
            return 1630143625880932354L;
        }
        static String code() {
            return "mdmSync";
        }
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<String> LAST_FAULT_REASON = new TypedField<>(String.class, "lastFaultReason");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<LocalDateTime> QUERY_DATE = new TypedField<>(LocalDateTime.class, "queryDate");
        TypedField<Long> LAST_QUERY_PAGE = new TypedField<>(Long.class, "lastQueryPage");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> TOTAL_COUNT = new TypedField<>(Long.class, "totalCount");
        TypedField<Long> PAGE_COUNT = new TypedField<>(Long.class, "pageCount");
        TypedField<Long> PAGE_SIZE = new TypedField<>(Long.class, "pageSize");
        TypedField<Long> PULL_TOTAL = new TypedField<>(Long.class, "pullTotal");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1630880771835809794L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<String> USER_CONTEXT = new TypedField<>(String.class, "userContext");
        TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "nodeHistory");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1630880772343320578L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        /**
         * 对一关联关系 关联对象 flowInstanceLog
         */
        TypedField<Long> ONETOMANY_ID = new TypedField<>(Long.class, "onetomany.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONETOMANY {
                static String code () {
                    return "onetomany" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "onetomany.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "onetomany.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "onetomany.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "onetomany.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "onetomany.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "onetomany.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "onetomany.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "onetomany.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "onetomany.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "onetomany.delete_flag");
                TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "onetomany.instanceId");
                TypedField<String> FLOW_CODE = new TypedField<>(String.class, "onetomany.flowCode");
                TypedField<String> ERROR_MSG = new TypedField<>(String.class, "onetomany.errorMsg");
                TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "onetomany.exceptionTrace");
                TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "onetomany.errorNodeId");
                TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "onetomany.rollback");
                TypedField<String> SNAPSHOT = new TypedField<>(String.class, "onetomany.snapshot");
                TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "onetomany.snapshotFormat");
                TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "onetomany.rollbackNodeId");
                TypedField<String> FLOW_NAME = new TypedField<>(String.class, "onetomany.flowName");
                TypedField<String> STATUS = new TypedField<>(String.class, "onetomany.status");
                TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "onetomany.startSnapshot");
                TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "onetomany.startSnapshotFormat");
                TypedField<String> USER_CONTEXT = new TypedField<>(String.class, "onetomany.userContext");
                TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "onetomany.nodeHistory");
            }
        }
    }
    public interface InvoiceMain {
        static Long id() {
            return 1635165804875526145L;
        }
        static String code() {
            return "invoiceMain";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "sellerAddrTel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "sellerBankInfo");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaserAddrTel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaserBankAccount");
        TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "purchaserBankInfo");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "businessStatus");
        TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "errorReasonEnum");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<Long> BILLING_COUNT = new TypedField<>(Long.class, "billingCount");
        TypedField<String> SALE_LIST_FILE_FLAG = new TypedField<>(String.class, "saleListFileFlag");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> RAW_INVOICE_NO = new TypedField<>(String.class, "rawInvoiceNo");
        TypedField<LocalDateTime> LAST_EXPORT_TIME = new TypedField<>(LocalDateTime.class, "lastExportTime");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<String> EXPORT_FILE_NAME = new TypedField<>(String.class, "exportFileName");
        TypedField<String> RED_FLAG = new TypedField<>(String.class, "redFlag");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<String> RED_STATUS = new TypedField<>(String.class, "redStatus");
        TypedField<String> RED_USER_ID = new TypedField<>(String.class, "redUserId");
        TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "redUserName");
        TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "retreatStatus");
        TypedField<String> BILLING_NOS = new TypedField<>(String.class, "billingNos");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paperDrewDate");
        TypedField<String> BUSINESS_SALES_NO = new TypedField<>(String.class, "businessSalesNo");
        TypedField<String> RELATION_SALES_NO = new TypedField<>(String.class, "relationSalesNo");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceColor");
        TypedField<Long> INVOICE_DETAILS_COUNT = new TypedField<>(Long.class, "invoiceDetailsCount");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvoiceDetail {
        static Long id() {
            return 1635167528086470658L;
        }
        static String code() {
            return "invoiceDetail";
        }
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> PRE_INVOICE_ID = new TypedField<>(String.class, "preInvoiceId");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbillItemNo");
        TypedField<String> PRE_INVOICE_ITEM_ID = new TypedField<>(String.class, "preInvoiceItemId");
        TypedField<String> SALESBILL_ITEM_ID = new TypedField<>(String.class, "salesbillItemId");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> CARGO_CODE = new TypedField<>(String.class, "cargoCode");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargoName");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<String> GOODS_NO_VER = new TypedField<>(String.class, "goodsNoVer");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> DISCOUNT_FLAG = new TypedField<>(String.class, "discountFlag");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> PRINT_CONTENT_FLAG = new TypedField<>(String.class, "printContentFlag");
        TypedField<String> INVOICE_ITEM_ID = new TypedField<>(String.class, "invoiceItemId");
        TypedField<String> INVOICE_NOTICE_NO = new TypedField<>(String.class, "invoiceNoticeNo");
        TypedField<String> INVOICE_NOTICE_ITEM_ID = new TypedField<>(String.class, "invoiceNoticeItemId");
        TypedField<String> INVOICE_NOTICE_ITEM_NO = new TypedField<>(String.class, "invoiceNoticeItemNo");
        TypedField<String> PURCHASE_ORDER_NO = new TypedField<>(String.class, "purchaseOrderNo");
        TypedField<String> PURCHASE_ORDER_ITEM_ID = new TypedField<>(String.class, "purchaseOrderItemId");
        TypedField<String> PURCHASE_ORDER_ITEM_NO = new TypedField<>(String.class, "purchaseOrderItemNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unitPrice");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> DEDUCTION = new TypedField<>(String.class, "deduction");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> INVOICE_MAIN_DETAILS_RELATION_ID = new TypedField<>(Long.class, "invoiceMainDetailsRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_MAIN_DETAILS_RELATION {
                static String code () {
                    return "invoiceMainDetailsRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceMainDetailsRelation.invoiceCode");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceMainDetailsRelation.invoiceType");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceMainDetailsRelation.originInvoiceCode");
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.salesbillNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerAddress");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerBankAccount");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerBankInfo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerBankName");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceMainDetailsRelation.sellerTel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserAddress");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserBankAccount");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserBankInfo");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserBankName");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserTel");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserTaxNo");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceMainDetailsRelation.taxRate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceMainDetailsRelation.billType");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceMainDetailsRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceMainDetailsRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceMainDetailsRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainDetailsRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainDetailsRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceMainDetailsRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceMainDetailsRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceMainDetailsRelation.delete_flag");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceMainDetailsRelation.status");
                TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "invoiceMainDetailsRelation.businessStatus");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "invoiceMainDetailsRelation.errorReasonEnum");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "invoiceMainDetailsRelation.errorInfo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext20");
                TypedField<Long> BILLING_COUNT = new TypedField<>(Long.class, "invoiceMainDetailsRelation.billingCount");
                TypedField<String> SALE_LIST_FILE_FLAG = new TypedField<>(String.class, "invoiceMainDetailsRelation.saleListFileFlag");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceMainDetailsRelation.remark");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.invoicerName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.checkerName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.cashierName");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.purchaserName");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "invoiceMainDetailsRelation.taxAmount");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "invoiceMainDetailsRelation.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "invoiceMainDetailsRelation.amountWithoutTax");
                TypedField<String> RAW_INVOICE_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.rawInvoiceNo");
                TypedField<LocalDateTime> LAST_EXPORT_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainDetailsRelation.lastExportTime");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "invoiceMainDetailsRelation.retryCount");
                TypedField<String> EXPORT_FILE_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.exportFileName");
                TypedField<String> RED_FLAG = new TypedField<>(String.class, "invoiceMainDetailsRelation.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.redNotificationNo");
                TypedField<String> RED_STATUS = new TypedField<>(String.class, "invoiceMainDetailsRelation.redStatus");
                TypedField<String> RED_USER_ID = new TypedField<>(String.class, "invoiceMainDetailsRelation.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceMainDetailsRelation.redUserName");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceMainDetailsRelation.retreatStatus");
                TypedField<String> BILLING_NOS = new TypedField<>(String.class, "invoiceMainDetailsRelation.billingNos");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceMainDetailsRelation.paperDrewDate");
                TypedField<String> BUSINESS_SALES_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.businessSalesNo");
                TypedField<String> RELATION_SALES_NO = new TypedField<>(String.class, "invoiceMainDetailsRelation.relationSalesNo");
                TypedField<String> EXT21 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "invoiceMainDetailsRelation.ext25");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceMainDetailsRelation.invoiceColor");
                TypedField<Long> INVOICE_DETAILS_COUNT = new TypedField<>(Long.class, "invoiceMainDetailsRelation.invoiceDetailsCount");
            }
        }
    }
    public interface BillingInvoiceRelation {
        static Long id() {
            return 1635170385541525506L;
        }
        static String code() {
            return "billingInvoiceRelation";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> BILLING_NO = new TypedField<>(String.class, "billingNo");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> BILLING_INVOICE_RELATION_STATUS_ENUM = new TypedField<>(String.class, "billingInvoiceRelationStatusEnum");
        TypedField<String> EMS_CODE = new TypedField<>(String.class, "emsCode");
        TypedField<String> SALES_ORG_CODE = new TypedField<>(String.class, "salesOrgCode");
        TypedField<String> BILLING_MERGE_NO = new TypedField<>(String.class, "billingMergeNo");
        TypedField<String> ERROR_MESSAGE = new TypedField<>(String.class, "errorMessage");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> INVOICE_MAIN_BILLING_RELATION_ID = new TypedField<>(Long.class, "invoiceMainBillingRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_MAIN_BILLING_RELATION {
                static String code () {
                    return "invoiceMainBillingRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceMainBillingRelation.invoiceCode");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceMainBillingRelation.invoiceType");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceMainBillingRelation.originInvoiceCode");
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.salesbillNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerAddress");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerBankAccount");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerBankInfo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerBankName");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceMainBillingRelation.sellerTel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserAddress");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserBankAccount");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserBankInfo");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserBankName");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserTel");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserTaxNo");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceMainBillingRelation.taxRate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceMainBillingRelation.billType");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceMainBillingRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceMainBillingRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceMainBillingRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainBillingRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainBillingRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceMainBillingRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceMainBillingRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceMainBillingRelation.delete_flag");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceMainBillingRelation.status");
                TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "invoiceMainBillingRelation.businessStatus");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "invoiceMainBillingRelation.errorReasonEnum");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "invoiceMainBillingRelation.errorInfo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext20");
                TypedField<Long> BILLING_COUNT = new TypedField<>(Long.class, "invoiceMainBillingRelation.billingCount");
                TypedField<String> SALE_LIST_FILE_FLAG = new TypedField<>(String.class, "invoiceMainBillingRelation.saleListFileFlag");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceMainBillingRelation.remark");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.invoicerName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.checkerName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.cashierName");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.purchaserName");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "invoiceMainBillingRelation.taxAmount");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "invoiceMainBillingRelation.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "invoiceMainBillingRelation.amountWithoutTax");
                TypedField<String> RAW_INVOICE_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.rawInvoiceNo");
                TypedField<LocalDateTime> LAST_EXPORT_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainBillingRelation.lastExportTime");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "invoiceMainBillingRelation.retryCount");
                TypedField<String> EXPORT_FILE_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.exportFileName");
                TypedField<String> RED_FLAG = new TypedField<>(String.class, "invoiceMainBillingRelation.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.redNotificationNo");
                TypedField<String> RED_STATUS = new TypedField<>(String.class, "invoiceMainBillingRelation.redStatus");
                TypedField<String> RED_USER_ID = new TypedField<>(String.class, "invoiceMainBillingRelation.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceMainBillingRelation.redUserName");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceMainBillingRelation.retreatStatus");
                TypedField<String> BILLING_NOS = new TypedField<>(String.class, "invoiceMainBillingRelation.billingNos");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceMainBillingRelation.paperDrewDate");
                TypedField<String> BUSINESS_SALES_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.businessSalesNo");
                TypedField<String> RELATION_SALES_NO = new TypedField<>(String.class, "invoiceMainBillingRelation.relationSalesNo");
                TypedField<String> EXT21 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "invoiceMainBillingRelation.ext25");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceMainBillingRelation.invoiceColor");
                TypedField<Long> INVOICE_DETAILS_COUNT = new TypedField<>(Long.class, "invoiceMainBillingRelation.invoiceDetailsCount");
            }
        }
    }
    public interface EmailRecord {
        static Long id() {
            return 1635917437649596418L;
        }
        static String code() {
            return "emailRecord";
        }
        TypedField<String> RECIPIENT_EMAIL = new TypedField<>(String.class, "recipientEmail");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> MAIL_SENDI_SCENARIO = new TypedField<>(String.class, "mailSendiScenario");
        TypedField<String> BODY = new TypedField<>(String.class, "body");
        TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "sendCount");
        TypedField<String> EMAIL_STATUS = new TypedField<>(String.class, "emailStatus");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
    }
    public interface EmailConfig {
        static Long id() {
            return 1635924665954209793L;
        }
        static String code() {
            return "emailConfig";
        }
        TypedField<String> MAIL_SENDI_SCENARIO = new TypedField<>(String.class, "mailSendiScenario");
        TypedField<String> RECIPIENT_EMAIL = new TypedField<>(String.class, "recipientEmail");
        TypedField<String> TEMPLATE_CODE = new TypedField<>(String.class, "templateCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface EmailTodoTask {
        static Long id() {
            return 1636197027238445057L;
        }
        static String code() {
            return "emailTodoTask";
        }
        TypedField<String> SUBJECT = new TypedField<>(String.class, "subject");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "businessId");
        TypedField<String> RECEIVER_EMAIL = new TypedField<>(String.class, "receiverEmail");
        TypedField<String> EMAIL_TEMPLATE_CODE = new TypedField<>(String.class, "emailTemplateCode");
    }
    public interface TodoTask {
        static Long id() {
            return 1636197027481714689L;
        }
        static String code() {
            return "todoTask";
        }
        TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "businessId");
        TypedField<String> TODO_TASK_TOPIC = new TypedField<>(String.class, "todoTaskTopic");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<Boolean> DELIVERY_STATUS = new TypedField<>(Boolean.class, "deliveryStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface DeliveredTodoTask {
        static Long id() {
            return 1636197027657875458L;
        }
        static String code() {
            return "deliveredTodoTask";
        }
        TypedField<String> TASK_STATUS = new TypedField<>(String.class, "taskStatus");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "businessId");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<String> TOPIC = new TypedField<>(String.class, "topic");
        TypedField<String> SUBSCRIBER_NAME = new TypedField<>(String.class, "subscriberName");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<LocalDateTime> NEXT_RETRY_TIME = new TypedField<>(LocalDateTime.class, "nextRetryTime");
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        /**
         * 对一关联关系 关联对象 todoTask
         */
        TypedField<Long> DELIVERY_TODO_TASK_MANY_TO_ONE_TODO_TASK_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface DELIVERY_TODO_TASK_MANY_TO_ONE_TODO_TASK {
                static String code () {
                    return "deliveryTodoTaskManyToOneTodoTask" ;
                }
                TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.businessId");
                TypedField<String> TODO_TASK_TOPIC = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.todoTaskTopic");
                TypedField<String> CONTENT = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.content");
                TypedField<Boolean> DELIVERY_STATUS = new TypedField<>(Boolean.class, "deliveryTodoTaskManyToOneTodoTask.deliveryStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "deliveryTodoTaskManyToOneTodoTask.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "deliveryTodoTaskManyToOneTodoTask.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.delete_flag");
            }
        }
    }
    public interface DeliveryRuleConfig {
        static Long id() {
            return 1636197027972448257L;
        }
        static String code() {
            return "deliveryRuleConfig";
        }
        TypedField<String> TOPIC = new TypedField<>(String.class, "topic");
        TypedField<String> SUBSCRIBER_NAME = new TypedField<>(String.class, "subscriberName");
        TypedField<Long> MAX_RETRY_COUNT = new TypedField<>(Long.class, "maxRetryCount");
        TypedField<Boolean> IS_OPEN = new TypedField<>(Boolean.class, "isOpen");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> INTERVAL = new TypedField<>(Long.class, "interval");
    }
    public interface PurchaseOrder {
        static Long id() {
            return 1636197028236689410L;
        }
        static String code() {
            return "purchaseOrder";
        }
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface OpenARVoucher {
        static Long id() {
            return 1638845859266359298L;
        }
        static String code() {
            return "openARVoucher";
        }
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BILLING_DOCUMENT = new TypedField<>(String.class, "billingDocument");
        TypedField<String> ASSIGNMENT = new TypedField<>(String.class, "assignment");
        TypedField<String> DOCUMENT_NUMBER = new TypedField<>(String.class, "documentNumber");
        TypedField<String> AMOUNT_IN_DOC_CURR = new TypedField<>(String.class, "amountInDocCurr");
        TypedField<String> DOCUMENT_TYPE = new TypedField<>(String.class, "documentType");
        TypedField<String> DOCUMENT_HEADER_TEXT = new TypedField<>(String.class, "documentHeaderText");
        TypedField<String> REFERENCE = new TypedField<>(String.class, "reference");
        TypedField<String> ARREARS_AFTER_NET_DUE_DATE = new TypedField<>(String.class, "arrearsAfterNetDueDate");
        TypedField<String> TEXT = new TypedField<>(String.class, "text");
        TypedField<String> USER_NAME = new TypedField<>(String.class, "userName");
        TypedField<String> CLEARING_DOCUMENT = new TypedField<>(String.class, "clearingDocument");
        TypedField<String> SPECIAL_G_LIND = new TypedField<>(String.class, "specialGLind");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "errorReasonEnum");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<String> LINE_ITEM = new TypedField<>(String.class, "lineItem");
        TypedField<LocalDateTime> DOCUMENT_DATE = new TypedField<>(LocalDateTime.class, "documentDate");
        TypedField<LocalDateTime> NET_DUE_DATE = new TypedField<>(LocalDateTime.class, "netDueDate");
        TypedField<LocalDateTime> CLEARING_DATE = new TypedField<>(LocalDateTime.class, "clearingDate");
        TypedField<LocalDateTime> ENTRY_DATE = new TypedField<>(LocalDateTime.class, "entryDate");
        TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "postingDate");
        /**
         * 对一关联关系 关联对象 openARHead
         */
        TypedField<Long> OPEN_A_R_HEAD_AND_DETAIL_ID = new TypedField<>(Long.class, "openARHeadAndDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface OPEN_A_R_HEAD_AND_DETAIL {
                static String code () {
                    return "openARHeadAndDetail" ;
                }
                TypedField<String> GROUP_KEY = new TypedField<>(String.class, "openARHeadAndDetail.groupKey");
                TypedField<String> OPEN_A_R_STATUS_ENUM = new TypedField<>(String.class, "openARHeadAndDetail.openARStatusEnum");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "openARHeadAndDetail.errorReasonEnum");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "openARHeadAndDetail.errorInfo");
                TypedField<Long> ID = new TypedField<>(Long.class, "openARHeadAndDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "openARHeadAndDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "openARHeadAndDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "openARHeadAndDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "openARHeadAndDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "openARHeadAndDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "openARHeadAndDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "openARHeadAndDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "openARHeadAndDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "openARHeadAndDetail.delete_flag");
                TypedField<Long> BLOB_FILE_ID = new TypedField<>(Long.class, "openARHeadAndDetail.blobFileId");
            }
        }
    }
    public interface NoInvoiceNotesConfig {
        static Long id() {
            return 1648273872700112897L;
        }
        static String code() {
            return "noInvoiceNotesConfig";
        }
        TypedField<String> NOTES = new TypedField<>(String.class, "notes");
        TypedField<String> NO_INVOICE_STATUS = new TypedField<>(String.class, "noInvoiceStatus");
        TypedField<String> NO_INVOICE_REASON = new TypedField<>(String.class, "noInvoiceReason");
        TypedField<Boolean> ENABLE = new TypedField<>(Boolean.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface NoInvoiceBillingTypeConfig {
        static Long id() {
            return 1648274545944137730L;
        }
        static String code() {
            return "noInvoiceBillingTypeConfig";
        }
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> NO_INVOICE_STATUS = new TypedField<>(String.class, "noInvoiceStatus");
        TypedField<String> NO_INVOICE_REASON = new TypedField<>(String.class, "noInvoiceReason");
        TypedField<Boolean> ENABLE = new TypedField<>(Boolean.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface NoInvoiceExceedAmountConfig {
        static Long id() {
            return 1648275306216751105L;
        }
        static String code() {
            return "noInvoiceExceedAmountConfig";
        }
        TypedField<String> CUSTOMER_TYPE = new TypedField<>(String.class, "customerType");
        TypedField<Boolean> ENABLE = new TypedField<>(Boolean.class, "enable");
        TypedField<String> NO_INVOICE_STATUS = new TypedField<>(String.class, "noInvoiceStatus");
        TypedField<String> NO_INVOICE_REASON = new TypedField<>(String.class, "noInvoiceReason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FileProcessLog {
        static Long id() {
            return 1650773936395845634L;
        }
        static String code() {
            return "fileProcessLog";
        }
        TypedField<LocalDateTime> CREATE_FILE_TIME = new TypedField<>(LocalDateTime.class, "createFileTime");
        TypedField<String> FILE_PROCESS_ENUM = new TypedField<>(String.class, "fileProcessEnum");
        TypedField<String> PROCESS_FILE_STATUS = new TypedField<>(String.class, "processFileStatus");
        TypedField<String> PROCESS_INFO = new TypedField<>(String.class, "processInfo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface InvoiceMergeNoRelation {
        static Long id() {
            return 1658412630461706242L;
        }
        static String code() {
            return "invoiceMergeNoRelation";
        }
        TypedField<String> BILLING_MERGE_NO = new TypedField<>(String.class, "billingMergeNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> INVOICE_MAIN_BILLING_MERGE_RELATION_ID = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_MAIN_BILLING_MERGE_RELATION {
                static String code () {
                    return "invoiceMainBillingMergeRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.invoiceCode");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.invoiceType");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.originInvoiceCode");
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.salesbillNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerAddress");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerBankAccount");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerBankInfo");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerBankName");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.sellerTel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserAddrTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserAddress");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserBankAccount");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserBankInfo");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserBankName");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserTel");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserTaxNo");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.taxRate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.billType");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainBillingMergeRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainBillingMergeRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.delete_flag");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.status");
                TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.businessStatus");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.errorReasonEnum");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.errorInfo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext20");
                TypedField<Long> BILLING_COUNT = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.billingCount");
                TypedField<String> SALE_LIST_FILE_FLAG = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.saleListFileFlag");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.remark");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.invoicerName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.checkerName");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.cashierName");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.purchaserName");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.taxAmount");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.amountWithoutTax");
                TypedField<String> RAW_INVOICE_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.rawInvoiceNo");
                TypedField<LocalDateTime> LAST_EXPORT_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainBillingMergeRelation.lastExportTime");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.retryCount");
                TypedField<String> EXPORT_FILE_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.exportFileName");
                TypedField<String> RED_FLAG = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.redNotificationNo");
                TypedField<String> RED_STATUS = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.redStatus");
                TypedField<String> RED_USER_ID = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.redUserName");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.retreatStatus");
                TypedField<String> BILLING_NOS = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.billingNos");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceMainBillingMergeRelation.paperDrewDate");
                TypedField<String> BUSINESS_SALES_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.businessSalesNo");
                TypedField<String> RELATION_SALES_NO = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.relationSalesNo");
                TypedField<String> EXT21 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.ext25");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceMainBillingMergeRelation.invoiceColor");
                TypedField<Long> INVOICE_DETAILS_COUNT = new TypedField<>(Long.class, "invoiceMainBillingMergeRelation.invoiceDetailsCount");
            }
        }
    }
    public interface OpenARHead {
        static Long id() {
            return 1661984121449189377L;
        }
        static String code() {
            return "openARHead";
        }
        TypedField<String> GROUP_KEY = new TypedField<>(String.class, "groupKey");
        TypedField<String> OPEN_A_R_STATUS_ENUM = new TypedField<>(String.class, "openARStatusEnum");
        TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "errorReasonEnum");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> BLOB_FILE_ID = new TypedField<>(Long.class, "blobFileId");
        /**
         * 对一关联关系 关联对象 blobFiles
         */
        TypedField<Long> BLOB_FILES_OPEN_A_R_HEADS_ID = new TypedField<>(Long.class, "blobFilesOpenARHeads.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BLOB_FILES_OPEN_A_R_HEADS {
                static String code () {
                    return "blobFilesOpenARHeads" ;
                }
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "blobFilesOpenARHeads.fileName");
                TypedField<String> FILE_STATUS = new TypedField<>(String.class, "blobFilesOpenARHeads.fileStatus");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "blobFilesOpenARHeads.fileType");
                TypedField<String> FILE_FORMAT = new TypedField<>(String.class, "blobFilesOpenARHeads.fileFormat");
                TypedField<Long> ID = new TypedField<>(Long.class, "blobFilesOpenARHeads.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "blobFilesOpenARHeads.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "blobFilesOpenARHeads.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "blobFilesOpenARHeads.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "blobFilesOpenARHeads.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "blobFilesOpenARHeads.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "blobFilesOpenARHeads.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "blobFilesOpenARHeads.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "blobFilesOpenARHeads.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "blobFilesOpenARHeads.delete_flag");
                TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "blobFilesOpenARHeads.retryCount");
                TypedField<String> FILE_DIRECTORY = new TypedField<>(String.class, "blobFilesOpenARHeads.fileDirectory");
                TypedField<String> FILE_ARCHIVE_DIRECTORY = new TypedField<>(String.class, "blobFilesOpenARHeads.fileArchiveDirectory");
                TypedField<String> ERROR_INFO = new TypedField<>(String.class, "blobFilesOpenARHeads.errorInfo");
                TypedField<String> ERROR_REASON_ENUM = new TypedField<>(String.class, "blobFilesOpenARHeads.errorReasonEnum");
                TypedField<Long> PROCESS_INDEX = new TypedField<>(Long.class, "blobFilesOpenARHeads.processIndex");
            }
        }
    }
    public interface BillingTypeWriteOffConfig {
        static Long id() {
            return 1663086359602606081L;
        }
        static String code() {
            return "billingTypeWriteOffConfig";
        }
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> P_BILLING_TYPE = new TypedField<>(String.class, "pBillingType");
        TypedField<String> P_WRITE_OFF_TYPE = new TypedField<>(String.class, "pWriteOffType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
