package com.xforceplus.ultraman.app.jcunilever.metadata.validator;

import com.xforceplus.ultraman.app.jcunilever.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcunilever.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(ApplyType.class)) {
            isValid = null != ApplyType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementStatus.class)) {
            isValid = null != SettlementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeInvoiceStatus.class)) {
            isValid = null != MakeInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MakeInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SubmitInvoiceStatus.class)) {
            isValid = null != SubmitInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SubmitInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(HeaderType.class)) {
            isValid = null != HeaderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HeaderType.class.getSimpleName());
            }
        }
        if(clazz.equals(ForceInvoice.class)) {
            isValid = null != ForceInvoice.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ForceInvoice.class.getSimpleName());
            }
        }
        if(clazz.equals(IsConsistent.class)) {
            isValid = null != IsConsistent.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsConsistent.class.getSimpleName());
            }
        }
        if(clazz.equals(PayTypeDesc.class)) {
            isValid = null != PayTypeDesc.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PayTypeDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(TradeType.class)) {
            isValid = null != TradeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsContainsRefundBeforeSettle.class)) {
            isValid = null != IsContainsRefundBeforeSettle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsContainsRefundBeforeSettle.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowTypeDesc.class)) {
            isValid = null != FlowTypeDesc.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowTypeDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderType.class)) {
            isValid = null != OrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataOrig.class)) {
            isValid = null != DataOrig.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOrig.class)) {
            isValid = null != InvoiceOrig.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(StoreName.class)) {
            isValid = null != StoreName.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StoreName.class.getSimpleName());
            }
        }
        if(clazz.equals(FileStatus.class)) {
            isValid = null != FileStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FileType.class)) {
            isValid = null != FileType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileType.class.getSimpleName());
            }
        }
        if(clazz.equals(FileFormat.class)) {
            isValid = null != FileFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceObj.class)) {
            isValid = null != ProduceObj.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceObj.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceStatus.class)) {
            isValid = null != ProduceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceType.class)) {
            isValid = null != ProduceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceSource.class)) {
            isValid = null != ProduceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProduceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessUnit.class)) {
            isValid = null != BusinessUnit.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceStatus.class)) {
            isValid = null != NoInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = null != HandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleFaultReason.class)) {
            isValid = null != HandleFaultReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleFaultReason.class.getSimpleName());
            }
        }
        if(clazz.equals(Whether.class)) {
            isValid = null != Whether.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Whether.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomerType.class)) {
            isValid = null != CustomerType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomerType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoicingMode.class)) {
            isValid = null != InvoicingMode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoicingMode.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormat.class)) {
            isValid = null != SnaphostFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnaphostFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PartnerFuc.class)) {
            isValid = null != PartnerFuc.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PartnerFuc.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeMDM.class)) {
            isValid = null != InvoiceTypeMDM.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceTypeMDM.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessStatus.class)) {
            isValid = null != BusinessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ErrorReasonEnum.class)) {
            isValid = null != ErrorReasonEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErrorReasonEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailStatus.class)) {
            isValid = null != EmailStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EmailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskStatus.class)) {
            isValid = null != TaskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TodoTaskTopic.class)) {
            isValid = null != TodoTaskTopic.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TodoTaskTopic.class.getSimpleName());
            }
        }
        if(clazz.equals(SubscriberName.class)) {
            isValid = null != SubscriberName.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SubscriberName.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingInvoiceRelationStatusEnum.class)) {
            isValid = null != BillingInvoiceRelationStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillingInvoiceRelationStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceReason.class)) {
            isValid = null != NoInvoiceReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoInvoiceReason.class.getSimpleName());
            }
        }
        if(clazz.equals(FileProcessEnum.class)) {
            isValid = null != FileProcessEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileProcessEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessFileStatus.class)) {
            isValid = null != ProcessFileStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProcessFileStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OpenARStatusEnum.class)) {
            isValid = null != OpenARStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OpenARStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PBillingType.class)) {
            isValid = null != PBillingType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PBillingType.class.getSimpleName());
            }
        }
        if(clazz.equals(PWriteOffType.class)) {
            isValid = null != PWriteOffType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PWriteOffType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
