package com.xforceplus.ultraman.app.jcunilever.metadata.validator;

import com.xforceplus.ultraman.app.jcunilever.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcunilever.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(ApplyType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MakeInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MakeInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SubmitInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SubmitInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SubmitInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(HeaderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HeaderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HeaderType.class.getSimpleName());
            }
        }
        if(clazz.equals(ForceInvoice.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ForceInvoice.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ForceInvoice.class.getSimpleName());
            }
        }
        if(clazz.equals(IsConsistent.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsConsistent.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsConsistent.class.getSimpleName());
            }
        }
        if(clazz.equals(PayTypeDesc.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PayTypeDesc.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PayTypeDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(TradeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TradeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsContainsRefundBeforeSettle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsContainsRefundBeforeSettle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsContainsRefundBeforeSettle.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowTypeDesc.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowTypeDesc.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowTypeDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataOrig.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataOrig.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOrig.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceOrig.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(StoreName.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StoreName.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StoreName.class.getSimpleName());
            }
        }
        if(clazz.equals(FileStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FileType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileType.class.getSimpleName());
            }
        }
        if(clazz.equals(FileFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceObj.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceObj.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceObj.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessUnit.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessUnit.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleFaultReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleFaultReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleFaultReason.class.getSimpleName());
            }
        }
        if(clazz.equals(Whether.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Whether.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Whether.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomerType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CustomerType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CustomerType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoicingMode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoicingMode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoicingMode.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnaphostFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnaphostFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PartnerFuc.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PartnerFuc.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PartnerFuc.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeMDM.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceTypeMDM.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceTypeMDM.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ErrorReasonEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErrorReasonEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErrorReasonEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EmailStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EmailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TodoTaskTopic.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TodoTaskTopic.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TodoTaskTopic.class.getSimpleName());
            }
        }
        if(clazz.equals(SubscriberName.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SubscriberName.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SubscriberName.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingInvoiceRelationStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingInvoiceRelationStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingInvoiceRelationStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoInvoiceReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoInvoiceReason.class.getSimpleName());
            }
        }
        if(clazz.equals(FileProcessEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileProcessEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileProcessEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessFileStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProcessFileStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProcessFileStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OpenARStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OpenARStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OpenARStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PBillingType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PBillingType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PBillingType.class.getSimpleName());
            }
        }
        if(clazz.equals(PWriteOffType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PWriteOffType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PWriteOffType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
