package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-26
 */
public enum FileType {

    BILLING("Billing", "发货凭证"),
    INVOICE_MATCH("InvoiceMatch", "配票凭证"),
    STATEMENT("Statement", "月度对账单"),
    OPEN_A_R("OpenAR", "未清凭证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileType fromCode(String code) {
        return Stream.of(FileType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
