package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 不开票原因
 * </p>
 *
 * @author ultraman
 * @since 2023-06-26
 */
public enum NoInvoiceReason {

    _1("1", "开票主数据不健全"),
    _2("2", "Cancel billing不出票"),
    _3("3", "改票不出票 (包括IC znon调整）"),
    _4("4", "正负对捏不出票"),
    _5("5", "不需要发票客户不开票-无公函"),
    _6("6", "不需要发票客户不开票-有公函"),
    _7("7", "Inteco正负抵消负值后期补开"),
    _8("8", "折扣折让手工开票"),
    _9("9", "配票客户未通知开票"),
    _10("10", "正负价差调整单不开票(IC客户）"),
    _11("11", "申请坏账不开票"),
    _12("12", "事后退回-ZRE订单"),
    _13("13", "票扣冲红"),
    _14("14", "DTC消费者发票"),
    _15("15", "其它"),
    _16("16", "未通知开票一般纳税人"),
    _17("17", "未通知开票小规模纳税人"),
    _18("18", "税额为零或者价税为零"),
    _19("19", "超过发票限额");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoInvoiceReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoInvoiceReason fromCode(String code) {
        return Stream.of(NoInvoiceReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
