package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 平台单据类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-26
 */
public enum PBillingType {

    NORMAL("NORMAL", "正常"),
    ADJUSTED("ADJUSTED", "调整"),
    WRITE_OFF("WRITE_OFF", "红冲"),
    CANCEL_WRITE_OFF("CANCEL_WRITE_OFF", "蓝冲"),
    OTHERS("OTHERS", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PBillingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PBillingType fromCode(String code) {
        return Stream.of(PBillingType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
