package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 平台冲销类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-26
 */
public enum PWriteOffType {

    NON("NON", "非冲销"),
    WRITE_OFF("WRITE_OFF", "红冲"),
    CANCEL_WRITE_OFF("CANCEL_WRITE_OFF", "蓝冲");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PWriteOffType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PWriteOffType fromCode(String code) {
        return Stream.of(PWriteOffType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
