package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理文件状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-26
 */
public enum ProcessFileStatus {

    _1("1", "成功"),
    _99("99", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessFileStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessFileStatus fromCode(String code) {
        return Stream.of(ProcessFileStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
