package com.xforceplus.ultraman.app.jcunilever.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_match_init
 * </p>
 *
 * @author ultraman
 * @since 2023-06-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMatchInit implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * billing编号
   */
  private String billingDocument;
  /**
   * 操作者
   */
  private String userName;
  /**
   * G/L Account
   */
  private String glAccount;
  /**
   * 付款方编号
   */
  private String customer;
  /**
   * 分配信息
   */
  private String assignment;
  /**
   * Invoice reference
   */
  private String invoiceReference;
  /**
   * 关联信息
   */
  private String reference;
  /**
   * 凭证号
   */
  private String documentNumber;
  /**
   * 凭证日期
   */
  private String documentDate;
  /**
   * Posting Date
   */
  private String postingDate;
  /**
   * Time of Entry
   */
  private String timeOfEntry;
  /**
   * 付款到期日
   */
  private String netDueDate;
  /**
   * Payment Method
   */
  private String paymentMethod;
  /**
   * Amount in local currency
   */
  private String amountInLocalCurrency;
  /**
   * 文本
   */
  private String text;
  /**
   * 凭证头文本信息
   */
  private String documentHeaderText;
  /**
   * FlowType
   */
  private String flowType;
  /**
   * Sp.G/L trans.type
   */
  private String spGLTransType;
  /**
   * 凭证类型
   */
  private String documentType;
  /**
   * 特殊总账标识
   */
  private String specialGLInd;
  /**
   * 预期天数
   */
  private String arrearsAfterNetDueDate;
  /**
   * 销方公司编号
   */
  private String companyCode;
  /**
   * postingKey
   */
  private String postingKey;
  /**
   * 清账凭证
   */
  private String clearingDocument;
  /**
   * branchAccount
   */
  private String branchAccount;
  /**
   * referenceKey3
   */
  private String referenceKey3;
  /**
   * paymentReference
   */
  private String paymentReference;

  /**
   * 对一关联关系 关联对象 blobFiles
   */
  private Long blobFilesInvoiceMatchId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billingDocument", billingDocument);
      map.put("userName", userName);
      map.put("glAccount", glAccount);
      map.put("customer", customer);
      map.put("assignment", assignment);
      map.put("invoiceReference", invoiceReference);
      map.put("reference", reference);
      map.put("documentNumber", documentNumber);
      map.put("documentDate", documentDate);
      map.put("postingDate", postingDate);
      map.put("timeOfEntry", timeOfEntry);
      map.put("netDueDate", netDueDate);
      map.put("paymentMethod", paymentMethod);
      map.put("amountInLocalCurrency", amountInLocalCurrency);
      map.put("text", text);
      map.put("documentHeaderText", documentHeaderText);
      map.put("flowType", flowType);
      map.put("spGLTransType", spGLTransType);
      map.put("documentType", documentType);
      map.put("specialGLInd", specialGLInd);
      map.put("arrearsAfterNetDueDate", arrearsAfterNetDueDate);
      map.put("companyCode", companyCode);
      map.put("postingKey", postingKey);
      map.put("clearingDocument", clearingDocument);
      map.put("branchAccount", branchAccount);
      map.put("referenceKey3", referenceKey3);
      map.put("paymentReference", paymentReference);

      map.put("blobFilesInvoiceMatch.id", blobFilesInvoiceMatchId);
      return map;
  }

  public static InvoiceMatchInit fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMatchInit entity = new InvoiceMatchInit();

    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("glAccount")) {
      Object obj = map.get("glAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGlAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssignment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceReference")) {
      Object obj = map.get("invoiceReference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("timeOfEntry")) {
      Object obj = map.get("timeOfEntry");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTimeOfEntry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountInLocalCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentHeaderText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowType")) {
      Object obj = map.get("flowType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpGLTransType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialGLInd")) {
      Object obj = map.get("specialGLInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialGLInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArrearsAfterNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingKey")) {
      Object obj = map.get("postingKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostingKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchAccount")) {
      Object obj = map.get("branchAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBranchAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referenceKey3")) {
      Object obj = map.get("referenceKey3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReferenceKey3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentReference")) {
      Object obj = map.get("paymentReference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentReference((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("blobFilesInvoiceMatch.id")) {
       Object obj = map.get("blobFilesInvoiceMatch.id");
       if(obj instanceof Long) {
         entity.setBlobFilesInvoiceMatchId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setBlobFilesInvoiceMatchId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("glAccount")) {
      Object obj = map.get("glAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGlAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAssignment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceReference")) {
      Object obj = map.get("invoiceReference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPostingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("timeOfEntry")) {
      Object obj = map.get("timeOfEntry");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTimeOfEntry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmountInLocalCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentHeaderText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowType")) {
      Object obj = map.get("flowType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFlowType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpGLTransType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialGLInd")) {
      Object obj = map.get("specialGLInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialGLInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setArrearsAfterNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingKey")) {
      Object obj = map.get("postingKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPostingKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchAccount")) {
      Object obj = map.get("branchAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBranchAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referenceKey3")) {
      Object obj = map.get("referenceKey3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReferenceKey3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentReference")) {
      Object obj = map.get("paymentReference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentReference((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("blobFilesInvoiceMatch.id")) {
    Object obj = map.get("blobFilesInvoiceMatch.id");
    if(obj instanceof Long) {
        this.setBlobFilesInvoiceMatchId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setBlobFilesInvoiceMatchId(Long.parseLong((String)obj));
    }
  }
  }
}
