package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件处理类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
public enum FileProcessEnum {

    TXT("txt", "txt"),
    EXCEL("excel", "excel");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileProcessEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileProcessEnum fromCode(String code) {
        return Stream.of(FileProcessEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
