package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
public enum FileProcessStatus {

    _0("0", "待RPA处理"),
    _1("1", "RPA处理完成"),
    _2("2", "RPA处理异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileProcessStatus fromCode(String code) {
        return Stream.of(FileProcessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
