package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否强制开票
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
public enum ForceInvoice {

    _0("0", "强制开票"),
    _1("1", "正常开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ForceInvoice(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ForceInvoice fromCode(String code) {
        return Stream.of(ForceInvoice.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
