package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
public enum InvoiceTypeMDM {

    _0("0", "普票"),
    _1("1", "专票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceTypeMDM(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeMDM fromCode(String code) {
        return Stream.of(InvoiceTypeMDM.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
