package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否默认
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
public enum IsDefault {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsDefault(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsDefault fromCode(String code) {
        return Stream.of(IsDefault.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
