package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务伙伴功能
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
public enum PartnerFuc {

    SP("SP", "SP"),
    BP("BP", "BP"),
    PY("PY", "PY"),
    SH("SH", "SH"),
    ZG("ZG", "ZG");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PartnerFuc(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PartnerFuc fromCode(String code) {
        return Stream.of(PartnerFuc.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
