package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 店铺名称
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
public enum StoreName {

    _4463798("4463798", "抖店开放平台测试专用店"),
    _4463799("4463799", "多芬个人护理旗舰店"),
    _25936620("25936620", "多芬个人护理旗舰店"),
    _25099124("25099124", "清扬官方旗舰店"),
    _25932221("25932221", "联合利华洗护清洁旗舰店"),
    _25155430("25155430", "凡士林官方旗舰店"),
    _21774349("21774349", "多芬官方旗舰店"),
    _15176405("15176405", "金纺官方旗舰店"),
    _25160730("25160730", "力士官方旗舰店"),
    _15101803("15101803", "A.H.C官方旗舰店"),
    _91677698("91677698", "regenerate官方旗舰店"),
    _98151635("98151635", "渡美TUNEMAKERS官方旗舰店"),
    _100432082("100432082", "力士洗护发"),
    _102388254("102388254", "多芬洗护发旗舰店"),
    _108527693("108527693", "中华牙膏官方旗舰店");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StoreName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StoreName fromCode(String code) {
        return Stream.of(StoreName.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
