package com.xforceplus.ultraman.app.jcunilever.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * mdm
 * </p>
 *
 * @author ultraman
 * @since 2023-09-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Mdm implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 客户代码
   */
  private String custCode;
  /**
   * 销售组织
   */
  private String saleOrgCode;
  /**
   * 客户组名称
   */
  private String tree1Level4Name;
  /**
   * 业务伙伴代码
   */
  private String toCode;
  /**
   * 业务伙伴名称
   */
  private String toName;
  /**
   * 是否电票
   */
  private String isElectronic;
  /**
   * 是否需要折扣明细
   */
  private String isDiscountDetails;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 是否默认
   */
  private String isDefault;
  /**
   * 业务伙伴功能
   */
  private String partnerFuc;
  /**
   * 电话
   */
  private String phone;
  /**
   * 地址
   */
  private String custAddr;
  /**
   * 纳税登记证号
   */
  private String vatRegistrationNo;
  /**
   * 银行代码
   */
  private String bankCode;
  /**
   * 银行名称
   */
  private String bankName;
  /**
   * 银行账号
   */
  private String bankAccountNo;
  /**
   * 银行类型
   */
  private String bankAccountType;
  /**
   * 收票邮箱
   */
  private String billingMail;
  /**
   * 删除标记
   */
  private String isDelete;
  /**
   * 唯一键
   */
  private String uniqueKey;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("custCode", custCode);
      map.put("saleOrgCode", saleOrgCode);
      map.put("tree1Level4Name", tree1Level4Name);
      map.put("toCode", toCode);
      map.put("toName", toName);
      map.put("isElectronic", isElectronic);
      map.put("isDiscountDetails", isDiscountDetails);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceType", invoiceType);
      map.put("isDefault", isDefault);
      map.put("partnerFuc", partnerFuc);
      map.put("phone", phone);
      map.put("custAddr", custAddr);
      map.put("vatRegistrationNo", vatRegistrationNo);
      map.put("bankCode", bankCode);
      map.put("bankName", bankName);
      map.put("bankAccountNo", bankAccountNo);
      map.put("bankAccountType", bankAccountType);
      map.put("billingMail", billingMail);
      map.put("isDelete", isDelete);
      map.put("uniqueKey", uniqueKey);

      return map;
  }

  public static Mdm fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Mdm entity = new Mdm();

    if(map.containsKey("custCode")) {
      Object obj = map.get("custCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleOrgCode")) {
      Object obj = map.get("saleOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tree1Level4Name")) {
      Object obj = map.get("tree1Level4Name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTree1Level4Name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toCode")) {
      Object obj = map.get("toCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toName")) {
      Object obj = map.get("toName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isElectronic")) {
      Object obj = map.get("isElectronic");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsElectronic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDiscountDetails")) {
      Object obj = map.get("isDiscountDetails");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsDiscountDetails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDefault")) {
      Object obj = map.get("isDefault");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsDefault((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("partnerFuc")) {
      Object obj = map.get("partnerFuc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPartnerFuc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phone")) {
      Object obj = map.get("phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custAddr")) {
      Object obj = map.get("custAddr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatRegistrationNo")) {
      Object obj = map.get("vatRegistrationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatRegistrationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankCode")) {
      Object obj = map.get("bankCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankAccountNo")) {
      Object obj = map.get("bankAccountNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankAccountNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankAccountType")) {
      Object obj = map.get("bankAccountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingMail")) {
      Object obj = map.get("billingMail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsDelete((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uniqueKey")) {
      Object obj = map.get("uniqueKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUniqueKey((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("custCode")) {
      Object obj = map.get("custCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleOrgCode")) {
      Object obj = map.get("saleOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSaleOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tree1Level4Name")) {
      Object obj = map.get("tree1Level4Name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTree1Level4Name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toCode")) {
      Object obj = map.get("toCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toName")) {
      Object obj = map.get("toName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isElectronic")) {
      Object obj = map.get("isElectronic");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsElectronic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDiscountDetails")) {
      Object obj = map.get("isDiscountDetails");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsDiscountDetails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDefault")) {
      Object obj = map.get("isDefault");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsDefault((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("partnerFuc")) {
      Object obj = map.get("partnerFuc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPartnerFuc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phone")) {
      Object obj = map.get("phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custAddr")) {
      Object obj = map.get("custAddr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatRegistrationNo")) {
      Object obj = map.get("vatRegistrationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVatRegistrationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankCode")) {
      Object obj = map.get("bankCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBankCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankAccountNo")) {
      Object obj = map.get("bankAccountNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBankAccountNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankAccountType")) {
      Object obj = map.get("bankAccountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBankAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingMail")) {
      Object obj = map.get("billingMail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsDelete((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uniqueKey")) {
      Object obj = map.get("uniqueKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUniqueKey((String)obj);
        }
      } else{
      }
    }
  }
}
