package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-28
 */
public enum BusinessStatus {

    _0("0", "待处理"),
    _1("1", "已创建Billing关系"),
    _4("4", "已回写合并参考号"),
    _2("2", "已上传发票文本"),
    _99("99", "处理异常"),
    _5("5", "已取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessStatus fromCode(String code) {
        return Stream.of(BusinessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
