package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * discount_list_pending_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-28
 */
public enum DiscountListPendingStatus {

    _0("0", "待生成PDF"),
    _1("1", "待发送"),
    _2("2", "已发送"),
    _3("3", "处理异常"),
    _4("4", "已取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DiscountListPendingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DiscountListPendingStatus fromCode(String code) {
        return Stream.of(DiscountListPendingStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
