package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type_m_d_m
 * </p>
 *
 * @author ultraman
 * @since 2023-11-28
 */
public enum InvoiceTypeMDM {

    _0("0", "普票"),
    _1("1", "专票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceTypeMDM(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeMDM fromCode(String code) {
        return Stream.of(InvoiceTypeMDM.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
