package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * produce_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-28
 */
public enum ProduceType {

    PUSH_BILLING_ORDER_POOL("PushBillingOrderPool", "biiling推送统一单据池"),
    PUSH_BILLING_UNION("PushBillingUnion", "biiling推送商联对账"),
    PUSH_BILLING("PushBilling", "推送billing单据"),
    PUSH_MDM("PushMdm", "推送Mdm"),
    PUSH_MDM_CONFIG("PushMdmConfig", "推送Mdm配置"),
    PUSH_MDM_TRAVELLING("PushMdmTravelling", "推送Mdm客商"),
    PUSH_NO_INVOICE_INFO("PushNoInvoiceInfo", "推送billing不开票原因"),
    UPDATE_OPEN_A_R_STATUS("UpdateOpenARStatus", "更新凭证文件处理完成状态");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProduceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceType fromCode(String code) {
        return Stream.of(ProduceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
