package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_orig
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
public enum DataOrig {

    _1("1", "接口传入"),
    _2("2", "页面导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataOrig(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataOrig fromCode(String code) {
        return Stream.of(DataOrig.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
