package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_source
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
public enum DataSource {

    SYSTEM_SYNC("systemSync", "系统同步"),
    MANUAL_IMPORT("manualImport", "手工导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSource fromCode(String code) {
        return Stream.of(DataSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
