package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * debit_credit_ind_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
public enum DebitCreditIndEnum {

    S("S", "借方"),
    H("H", "贷方");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DebitCreditIndEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DebitCreditIndEnum fromCode(String code) {
        return Stream.of(DebitCreditIndEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
