package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
public enum DocumentType {

    AB("AB", "AB"),
    D1("D1", "D1"),
    D3("D3", "D3"),
    DI("DI", "DI"),
    D4("D4", "D4"),
    DG("DG", "DG"),
    DZ("DZ", "DZ"),
    DA("DA", "DA"),
    DR("DR", "DR"),
    RS("RS", "RS"),
    RR("RR", "RR"),
    KZ("KZ", "KZ"),
    OP("OP", "OP"),
    ZP("ZP", "ZP"),
    ZV("ZV", "ZV"),
    ZK("ZK", "ZK");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocumentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentType fromCode(String code) {
        return Stream.of(DocumentType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
