package com.xforceplus.ultraman.app.jcunilever.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * statement
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Statement implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 对账单类型
   */
  private String statementType;
  /**
   * 销方公司编码
   */
  private String companyCode;
  /**
   * 已清未清标识
   */
  private String clearedOpenItemsSymbol;
  /**
   * 付款方编号
   */
  private String customer;
  /**
   * 凭证号
   */
  private String documentNumber;
  /**
   * 分配
   */
  private String assignment;
  /**
   * 参照
   */
  private String reference;
  /**
   * Billing编号
   */
  private String billingDocument;
  /**
   * 凭证类型
   */
  private String documentType;
  /**
   * 特殊总账标识
   */
  private String specialGLIND;
  /**
   * 文本
   */
  private String text;
  /**
   * 凭证抬头文本
   */
  private String documentHeaderText;
  /**
   * 参考关键字1
   */
  private String referenceKey1;
  /**
   * 对象关键字
   */
  private String objectKey;
  /**
   * 清账凭证
   */
  private String clearingDocument;
  /**
   * 录入日期
   */
  private String entryDate;
  /**
   * 特定总帐事务类型
   */
  private String spGLTransType;
  /**
   * 行项目
   */
  private String lineItem;
  /**
   * 文件名称
   */
  private String fileName;
  /**
   * 处理状态
   */
  private String status;
  /**
   * 拼接字段
   */
  private String mixText;
  /**
   * 销售组织
   */
  private String salesOrg;
  /**
   * 数据来源
   */
  private String dataSource;
  /**
   * 联合主键
   */
  private String mainIndex;
  /**
   * 过账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;
  /**
   * 凭证日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;
  /**
   * 净收付到期日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime netDueDate;
  /**
   * 逾期天数
   */
  private Long arrearsAfterNetDueDate;
  /**
   * 本币金额
   */
  private BigDecimal amountInLocalCurrency;
  /**
   * 借贷标识
   */
  private String debitCreditInd;
  /**
   * 显示货币的金额
   */
  private BigDecimal amountInDocCurr;
  /**
   * 清账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime clearingDate;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("statementType", statementType);
      map.put("companyCode", companyCode);
      map.put("clearedOpenItemsSymbol", clearedOpenItemsSymbol);
      map.put("customer", customer);
      map.put("documentNumber", documentNumber);
      map.put("assignment", assignment);
      map.put("reference", reference);
      map.put("billingDocument", billingDocument);
      map.put("documentType", documentType);
      map.put("specialGLIND", specialGLIND);
      map.put("text", text);
      map.put("documentHeaderText", documentHeaderText);
      map.put("referenceKey1", referenceKey1);
      map.put("objectKey", objectKey);
      map.put("clearingDocument", clearingDocument);
      map.put("entryDate", entryDate);
      map.put("spGLTransType", spGLTransType);
      map.put("lineItem", lineItem);
      map.put("fileName", fileName);
      map.put("status", status);
      map.put("mixText", mixText);
      map.put("salesOrg", salesOrg);
      map.put("dataSource", dataSource);
      map.put("mainIndex", mainIndex);
      map.put("postingDate", BocpGenUtils.toTimestamp(postingDate));
      map.put("documentDate", BocpGenUtils.toTimestamp(documentDate));
      map.put("netDueDate", BocpGenUtils.toTimestamp(netDueDate));
      map.put("arrearsAfterNetDueDate", arrearsAfterNetDueDate);
      map.put("amountInLocalCurrency", amountInLocalCurrency);
      map.put("debitCreditInd", debitCreditInd);
      map.put("amountInDocCurr", amountInDocCurr);
      map.put("clearingDate", BocpGenUtils.toTimestamp(clearingDate));

      return map;
  }

  public static Statement fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Statement entity = new Statement();

    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementType")) {
      Object obj = map.get("statementType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatementType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearedOpenItemsSymbol")) {
      Object obj = map.get("clearedOpenItemsSymbol");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearedOpenItemsSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssignment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialGLIND")) {
      Object obj = map.get("specialGLIND");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialGLIND((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentHeaderText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referenceKey1")) {
      Object obj = map.get("referenceKey1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReferenceKey1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("objectKey")) {
      Object obj = map.get("objectKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setObjectKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryDate")) {
      Object obj = map.get("entryDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpGLTransType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineItem")) {
      Object obj = map.get("lineItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mixText")) {
      Object obj = map.get("mixText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMixText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mainIndex")) {
      Object obj = map.get("mainIndex");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMainIndex((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNetDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setNetDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNetDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setNetDueDate(null);
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setArrearsAfterNetDueDate((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setArrearsAfterNetDueDate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setArrearsAfterNetDueDate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountInLocalCurrency((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountInLocalCurrency(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountInLocalCurrency(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountInLocalCurrency(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountInLocalCurrency(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("debitCreditInd")) {
      Object obj = map.get("debitCreditInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDebitCreditInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountInDocCurr")) {
      Object obj = map.get("amountInDocCurr");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountInDocCurr((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountInDocCurr(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountInDocCurr(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountInDocCurr(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountInDocCurr(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("clearingDate")) {
      Object obj = map.get("clearingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setClearingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setClearingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setClearingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setClearingDate(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementType")) {
      Object obj = map.get("statementType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatementType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearedOpenItemsSymbol")) {
      Object obj = map.get("clearedOpenItemsSymbol");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClearedOpenItemsSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAssignment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialGLIND")) {
      Object obj = map.get("specialGLIND");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialGLIND((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentHeaderText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referenceKey1")) {
      Object obj = map.get("referenceKey1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReferenceKey1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("objectKey")) {
      Object obj = map.get("objectKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setObjectKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryDate")) {
      Object obj = map.get("entryDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEntryDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpGLTransType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineItem")) {
      Object obj = map.get("lineItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLineItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mixText")) {
      Object obj = map.get("mixText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMixText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mainIndex")) {
      Object obj = map.get("mainIndex");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMainIndex((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPostingDate(null);
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDocumentDate(null);
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setNetDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setNetDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNetDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setNetDueDate(null);
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setArrearsAfterNetDueDate((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setArrearsAfterNetDueDate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setArrearsAfterNetDueDate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountInLocalCurrency((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountInLocalCurrency(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountInLocalCurrency(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountInLocalCurrency(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountInLocalCurrency(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("debitCreditInd")) {
      Object obj = map.get("debitCreditInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDebitCreditInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountInDocCurr")) {
      Object obj = map.get("amountInDocCurr");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountInDocCurr((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountInDocCurr(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountInDocCurr(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountInDocCurr(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountInDocCurr(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("clearingDate")) {
      Object obj = map.get("clearingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setClearingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setClearingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setClearingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setClearingDate(null);
      }
    }
  }
}
