package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * aggregate_amount_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
public enum AggregateAmountType {

    MATERIAL_MERGE("materialMerge", "物料合并"),
    ORDER_MERGE("orderMerge", "整单合并");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AggregateAmountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AggregateAmountType fromCode(String code) {
        return Stream.of(AggregateAmountType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
