package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * discount_description
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
public enum DiscountDescription {

    LONG_TERM_DISCOUNT("longTermDiscount", "长期折扣"),
    SHORT_TERM_DISCOUNT("shortTermDiscount", "短期折扣"),
    COVERAGE_REWARD("coverageReward", "覆盖奖励"),
    TICKET_DISCOUNT_TOTAL("ticketDiscountTotal", "票扣总额");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DiscountDescription(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DiscountDescription fromCode(String code) {
        return Stream.of(DiscountDescription.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
