package com.xforceplus.ultraman.app.jcunilever.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * statement_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
public enum StatementType {

    IC_OPEN_ITEMS("IC_OPEN_ITEMS", "IC票扣对账单 Open items"),
    IC_ALL_ITEMS("IC_ALL_ITEMS", "IC票扣对账单 All items"),
    BEGING_PERIOD_CN24("BEGING_PERIOD_CN24", "期初"),
    END_PERIOD_CN19("END_PERIOD_CN19", "期末"),
    HPC_CN08("HPC_CN08", "销售HPC"),
    IC_CN20("IC_CN20", "销售IC");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StatementType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StatementType fromCode(String code) {
        return Stream.of(StatementType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
