package com.xforceplus.ultraman.app.jcunilever.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * billing_head
 * </p>
 *
 * @author ultraman
 * @since 2024-03-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillingHead implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * billing单号
   */
  private String billingdocument;
  /**
   * 公司代码
   */
  private String companycode;
  /**
   * 销售组织
   */
  private String salesorganization;
  /**
   * 付款人代码
   */
  private String payer;
  /**
   * 付款人名称
   */
  private String nameofpayer;
  /**
   * 交易方代码
   */
  private String soldtoparty;
  /**
   * 交易方名称
   */
  private String nameofsoldtoparty;
  /**
   * 客户组
   */
  private String keycustomer4name;
  /**
   * 参考凭证编号
   */
  private String referencedocumentn;
  /**
   * billing日期
   */
  private String billingdate;
  /**
   * billing类型
   */
  private String billingtype;
  /**
   * 不含税金额
   */
  private String netvalue;
  /**
   * 税额
   */
  private String taxamount;
  /**
   * PO编号
   */
  private String ponumber;
  /**
   * 红字通知单编号
   */
  private String redivnoticeno;
  /**
   * 原始数据处理状态
   */
  private String status;
  /**
   * 异常原因
   */
  private String errorReasonEnum;
  /**
   * 异常信息
   */
  private String errorInfo;
  /**
   * 重试次数
   */
  private Long retryCount;
  /**
   * 重试时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime retryTime;
  /**
   * 平台单据类型
   */
  private String pBillingType;
  /**
   * 平台冲销类型
   */
  private String pWriteOffType;
  /**
   * 被冲销billing单号
   */
  private String pWriteOffBillingNo;
  /**
   * billing日期(仅供查询)
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billingDateNew;

  /**
   * 对一关联关系 关联对象 blobFiles
   */
  private Long blobFilesBillingHeadId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billingdocument", billingdocument);
      map.put("companycode", companycode);
      map.put("salesorganization", salesorganization);
      map.put("payer", payer);
      map.put("nameofpayer", nameofpayer);
      map.put("soldtoparty", soldtoparty);
      map.put("nameofsoldtoparty", nameofsoldtoparty);
      map.put("keycustomer4name", keycustomer4name);
      map.put("referencedocumentn", referencedocumentn);
      map.put("billingdate", billingdate);
      map.put("billingtype", billingtype);
      map.put("netvalue", netvalue);
      map.put("taxamount", taxamount);
      map.put("ponumber", ponumber);
      map.put("redivnoticeno", redivnoticeno);
      map.put("status", status);
      map.put("errorReasonEnum", errorReasonEnum);
      map.put("errorInfo", errorInfo);
      map.put("retryCount", retryCount);
      map.put("retryTime", BocpGenUtils.toTimestamp(retryTime));
      map.put("pBillingType", pBillingType);
      map.put("pWriteOffType", pWriteOffType);
      map.put("pWriteOffBillingNo", pWriteOffBillingNo);
      map.put("billingDateNew", BocpGenUtils.toTimestamp(billingDateNew));

      map.put("blobFilesBillingHead.id", blobFilesBillingHeadId);
      return map;
  }

  public static BillingHead fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillingHead entity = new BillingHead();

    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdocument")) {
      Object obj = map.get("billingdocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingdocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companycode")) {
      Object obj = map.get("companycode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanycode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesorganization")) {
      Object obj = map.get("salesorganization");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesorganization((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer")) {
      Object obj = map.get("payer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameofpayer")) {
      Object obj = map.get("nameofpayer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameofpayer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldtoparty")) {
      Object obj = map.get("soldtoparty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSoldtoparty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameofsoldtoparty")) {
      Object obj = map.get("nameofsoldtoparty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameofsoldtoparty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keycustomer4name")) {
      Object obj = map.get("keycustomer4name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKeycustomer4name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referencedocumentn")) {
      Object obj = map.get("referencedocumentn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReferencedocumentn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdate")) {
      Object obj = map.get("billingdate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingdate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingtype")) {
      Object obj = map.get("billingtype");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingtype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netvalue")) {
      Object obj = map.get("netvalue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetvalue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxamount")) {
      Object obj = map.get("taxamount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxamount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ponumber")) {
      Object obj = map.get("ponumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPonumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redivnoticeno")) {
      Object obj = map.get("redivnoticeno");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedivnoticeno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorReasonEnum")) {
      Object obj = map.get("errorReasonEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorReasonEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retryCount")) {
      Object obj = map.get("retryCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("retryTime")) {
      Object obj = map.get("retryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRetryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRetryTime(null);
      }
    }
    if(map.containsKey("pBillingType")) {
      Object obj = map.get("pBillingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffType")) {
      Object obj = map.get("pWriteOffType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPWriteOffType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffBillingNo")) {
      Object obj = map.get("pWriteOffBillingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPWriteOffBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDateNew")) {
      Object obj = map.get("billingDateNew");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillingDateNew(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillingDateNew((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillingDateNew(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillingDateNew(null);
      }
    }

    if(map.containsKey("blobFilesBillingHead.id")) {
       Object obj = map.get("blobFilesBillingHead.id");
       if(obj instanceof Long) {
         entity.setBlobFilesBillingHeadId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setBlobFilesBillingHeadId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdocument")) {
      Object obj = map.get("billingdocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingdocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companycode")) {
      Object obj = map.get("companycode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanycode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesorganization")) {
      Object obj = map.get("salesorganization");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesorganization((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer")) {
      Object obj = map.get("payer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameofpayer")) {
      Object obj = map.get("nameofpayer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNameofpayer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldtoparty")) {
      Object obj = map.get("soldtoparty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSoldtoparty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameofsoldtoparty")) {
      Object obj = map.get("nameofsoldtoparty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNameofsoldtoparty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keycustomer4name")) {
      Object obj = map.get("keycustomer4name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKeycustomer4name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referencedocumentn")) {
      Object obj = map.get("referencedocumentn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReferencedocumentn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdate")) {
      Object obj = map.get("billingdate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingdate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingtype")) {
      Object obj = map.get("billingtype");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingtype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netvalue")) {
      Object obj = map.get("netvalue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNetvalue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxamount")) {
      Object obj = map.get("taxamount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxamount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ponumber")) {
      Object obj = map.get("ponumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPonumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redivnoticeno")) {
      Object obj = map.get("redivnoticeno");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedivnoticeno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorReasonEnum")) {
      Object obj = map.get("errorReasonEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorReasonEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retryCount")) {
      Object obj = map.get("retryCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("retryTime")) {
      Object obj = map.get("retryTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRetryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRetryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRetryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRetryTime(null);
      }
    }
    if(map.containsKey("pBillingType")) {
      Object obj = map.get("pBillingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffType")) {
      Object obj = map.get("pWriteOffType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPWriteOffType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffBillingNo")) {
      Object obj = map.get("pWriteOffBillingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPWriteOffBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDateNew")) {
      Object obj = map.get("billingDateNew");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillingDateNew(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBillingDateNew((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillingDateNew(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBillingDateNew(null);
      }
    }
  if(map.containsKey("blobFilesBillingHead.id")) {
    Object obj = map.get("blobFilesBillingHead.id");
    if(obj instanceof Long) {
        this.setBlobFilesBillingHeadId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setBlobFilesBillingHeadId(Long.parseLong((String)obj));
    }
  }
  }
}
