package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.OrderMainCancel;
import com.xforceplus.ultraman.app.jcunilever.service.IOrderMainCancelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 订单已作废前端控制器
 *
 * @author ultraman
 * @date 2022-06-02
 */
@RestController
public class OrderMainCancelController {

  @Autowired
  private IOrderMainCancelService orderMainCancelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderMainCancel 订单已作废
   * @return
   */
  @GetMapping("/ordermaincancels" )
  public XfR getOrderMainCancels(XfPage page, OrderMainCancel orderMainCancel) {
    return XfR.ok(orderMainCancelServiceImpl.page(page, Wrappers.query(orderMainCancel)));
  }

  /**
   * 通过id查询订单已作废
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermaincancels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderMainCancelServiceImpl.getById(id));
  }

  /**
   * 新增订单已作废
   * @param orderMainCancel 订单已作废
   * @return XfR
   */
  @PostMapping("/ordermaincancels")
  public XfR save(@RequestBody OrderMainCancel orderMainCancel) {
     return XfR.ok(orderMainCancelServiceImpl.save(orderMainCancel));
  }

  /**
   * 修改-传入修改后的全部数据订单已作废
   * @param orderMainCancel 订单已作废
   * @return XfR
   */
  @PutMapping("/ordermaincancels/{id}")
  public XfR putUpdate(@RequestBody OrderMainCancel orderMainCancel,@PathVariable Long id) {
      orderMainCancel.setId(id);
      return XfR.ok(orderMainCancelServiceImpl.updateById(orderMainCancel));
  }

  /**
   * 修改-传入修改的数据订单已作废
   * @param orderMainCancel 订单已作废
   * @return XfR
   */
  @PatchMapping("/ordermaincancels/{id}")
  public XfR patchUpdate(@RequestBody OrderMainCancel orderMainCancel,@PathVariable Long id) {
      OrderMainCancel uporderMainCancel = orderMainCancelServiceImpl.getById(id);
      if(uporderMainCancel != null){
        uporderMainCancel = ObjectCopyUtils.copyProperties(orderMainCancel,uporderMainCancel,true);
      }
      return XfR.ok(orderMainCancelServiceImpl.updateById(uporderMainCancel));
  }

  /**
   * 通过id删除订单已作废
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermaincancels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderMainCancelServiceImpl.removeById(id));
  }

  @PostMapping("/ordermaincancels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_main_cancel");
     params.put("request", condition);

     return XfR.ok(orderMainCancelServiceImpl.querys(params));
  }

}
