package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.OrderMain;
import com.xforceplus.ultraman.app.jcunilever.service.IOrderMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 订单待开票前端控制器
 *
 * @author ultraman
 * @date 2022-06-02
 */
@RestController
public class OrderMainController {

  @Autowired
  private IOrderMainService orderMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderMain 订单待开票
   * @return
   */
  @GetMapping("/ordermains" )
  public XfR getOrderMains(XfPage page, OrderMain orderMain) {
    return XfR.ok(orderMainServiceImpl.page(page, Wrappers.query(orderMain)));
  }

  /**
   * 通过id查询订单待开票
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderMainServiceImpl.getById(id));
  }

  /**
   * 新增订单待开票
   * @param orderMain 订单待开票
   * @return XfR
   */
  @PostMapping("/ordermains")
  public XfR save(@RequestBody OrderMain orderMain) {
     return XfR.ok(orderMainServiceImpl.save(orderMain));
  }

  /**
   * 修改-传入修改后的全部数据订单待开票
   * @param orderMain 订单待开票
   * @return XfR
   */
  @PutMapping("/ordermains/{id}")
  public XfR putUpdate(@RequestBody OrderMain orderMain,@PathVariable Long id) {
      orderMain.setId(id);
      return XfR.ok(orderMainServiceImpl.updateById(orderMain));
  }

  /**
   * 修改-传入修改的数据订单待开票
   * @param orderMain 订单待开票
   * @return XfR
   */
  @PatchMapping("/ordermains/{id}")
  public XfR patchUpdate(@RequestBody OrderMain orderMain,@PathVariable Long id) {
      OrderMain uporderMain = orderMainServiceImpl.getById(id);
      if(uporderMain != null){
        uporderMain = ObjectCopyUtils.copyProperties(orderMain,uporderMain,true);
      }
      return XfR.ok(orderMainServiceImpl.updateById(uporderMain));
  }

  /**
   * 通过id删除订单待开票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderMainServiceImpl.removeById(id));
  }

  @PostMapping("/ordermains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_main");
     params.put("request", condition);

     return XfR.ok(orderMainServiceImpl.querys(params));
  }

}
