package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.OrderMainMake;
import com.xforceplus.ultraman.app.jcunilever.service.IOrderMainMakeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 订单已开票前端控制器
 *
 * @author ultraman
 * @date 2022-06-02
 */
@RestController
public class OrderMainMakeController {

  @Autowired
  private IOrderMainMakeService orderMainMakeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderMainMake 订单已开票
   * @return
   */
  @GetMapping("/ordermainmakes" )
  public XfR getOrderMainMakes(XfPage page, OrderMainMake orderMainMake) {
    return XfR.ok(orderMainMakeServiceImpl.page(page, Wrappers.query(orderMainMake)));
  }

  /**
   * 通过id查询订单已开票
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermainmakes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderMainMakeServiceImpl.getById(id));
  }

  /**
   * 新增订单已开票
   * @param orderMainMake 订单已开票
   * @return XfR
   */
  @PostMapping("/ordermainmakes")
  public XfR save(@RequestBody OrderMainMake orderMainMake) {
     return XfR.ok(orderMainMakeServiceImpl.save(orderMainMake));
  }

  /**
   * 修改-传入修改后的全部数据订单已开票
   * @param orderMainMake 订单已开票
   * @return XfR
   */
  @PutMapping("/ordermainmakes/{id}")
  public XfR putUpdate(@RequestBody OrderMainMake orderMainMake,@PathVariable Long id) {
      orderMainMake.setId(id);
      return XfR.ok(orderMainMakeServiceImpl.updateById(orderMainMake));
  }

  /**
   * 修改-传入修改的数据订单已开票
   * @param orderMainMake 订单已开票
   * @return XfR
   */
  @PatchMapping("/ordermainmakes/{id}")
  public XfR patchUpdate(@RequestBody OrderMainMake orderMainMake,@PathVariable Long id) {
      OrderMainMake uporderMainMake = orderMainMakeServiceImpl.getById(id);
      if(uporderMainMake != null){
        uporderMainMake = ObjectCopyUtils.copyProperties(orderMainMake,uporderMainMake,true);
      }
      return XfR.ok(orderMainMakeServiceImpl.updateById(uporderMainMake));
  }

  /**
   * 通过id删除订单已开票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermainmakes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderMainMakeServiceImpl.removeById(id));
  }

  @PostMapping("/ordermainmakes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_main_make");
     params.put("request", condition);

     return XfR.ok(orderMainMakeServiceImpl.querys(params));
  }

}
