package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BillingInit;
import com.xforceplus.ultraman.app.jcunilever.service.IBillingInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-01
 */
@RestController
public class BillingInitController {

  @Autowired
  private IBillingInitService billingInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingInit ${table.comment}
   * @return
   */
  @GetMapping("/billinginits" )
  public XfR getBillingInits(XfPage page, BillingInit billingInit) {
    return XfR.ok(billingInitServiceImpl.page(page, Wrappers.query(billingInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billinginits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/billinginits")
  public XfR save(@RequestBody BillingInit billingInit) {
     return XfR.ok(billingInitServiceImpl.save(billingInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/billinginits/{id}")
  public XfR putUpdate(@RequestBody BillingInit billingInit,@PathVariable Long id) {
      billingInit.setId(id);
      return XfR.ok(billingInitServiceImpl.updateById(billingInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billinginits/{id}")
  public XfR patchUpdate(@RequestBody BillingInit billingInit,@PathVariable Long id) {
      BillingInit upbillingInit = billingInitServiceImpl.getById(id);
      if(upbillingInit != null){
        upbillingInit = ObjectCopyUtils.copyProperties(billingInit,upbillingInit,true);
      }
      return XfR.ok(billingInitServiceImpl.updateById(upbillingInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billinginits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingInitServiceImpl.removeById(id));
  }

  @PostMapping("/billinginits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_init");
     params.put("request", condition);

     return XfR.ok(billingInitServiceImpl.querys(params));
  }

}
