package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BusinessUnitConfig;
import com.xforceplus.ultraman.app.jcunilever.service.IBusinessUnitConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-01
 */
@RestController
public class BusinessUnitConfigController {

  @Autowired
  private IBusinessUnitConfigService businessUnitConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessUnitConfig ${table.comment}
   * @return
   */
  @GetMapping("/businessunitconfigs" )
  public XfR getBusinessUnitConfigs(XfPage page, BusinessUnitConfig businessUnitConfig) {
    return XfR.ok(businessUnitConfigServiceImpl.page(page, Wrappers.query(businessUnitConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessunitconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessUnitConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessUnitConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/businessunitconfigs")
  public XfR save(@RequestBody BusinessUnitConfig businessUnitConfig) {
     return XfR.ok(businessUnitConfigServiceImpl.save(businessUnitConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessUnitConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/businessunitconfigs/{id}")
  public XfR putUpdate(@RequestBody BusinessUnitConfig businessUnitConfig,@PathVariable Long id) {
      businessUnitConfig.setId(id);
      return XfR.ok(businessUnitConfigServiceImpl.updateById(businessUnitConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessUnitConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businessunitconfigs/{id}")
  public XfR patchUpdate(@RequestBody BusinessUnitConfig businessUnitConfig,@PathVariable Long id) {
      BusinessUnitConfig upbusinessUnitConfig = businessUnitConfigServiceImpl.getById(id);
      if(upbusinessUnitConfig != null){
        upbusinessUnitConfig = ObjectCopyUtils.copyProperties(businessUnitConfig,upbusinessUnitConfig,true);
      }
      return XfR.ok(businessUnitConfigServiceImpl.updateById(upbusinessUnitConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessunitconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessUnitConfigServiceImpl.removeById(id));
  }

  @PostMapping("/businessunitconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_unit_config");
     params.put("request", condition);

     return XfR.ok(businessUnitConfigServiceImpl.querys(params));
  }

}
