package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.Mdm;
import com.xforceplus.ultraman.app.jcunilever.service.IMdmService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-01
 */
@RestController
public class MdmController {

  @Autowired
  private IMdmService mdmServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mdm ${table.comment}
   * @return
   */
  @GetMapping("/mdms" )
  public XfR getMdms(XfPage page, Mdm mdm) {
    return XfR.ok(mdmServiceImpl.page(page, Wrappers.query(mdm)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mdms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mdmServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param mdm ${table.comment}
   * @return XfR
   */
  @PostMapping("/mdms")
  public XfR save(@RequestBody Mdm mdm) {
     return XfR.ok(mdmServiceImpl.save(mdm));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param mdm ${table.comment}
   * @return XfR
   */
  @PutMapping("/mdms/{id}")
  public XfR putUpdate(@RequestBody Mdm mdm,@PathVariable Long id) {
      mdm.setId(id);
      return XfR.ok(mdmServiceImpl.updateById(mdm));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param mdm ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mdms/{id}")
  public XfR patchUpdate(@RequestBody Mdm mdm,@PathVariable Long id) {
      Mdm upmdm = mdmServiceImpl.getById(id);
      if(upmdm != null){
        upmdm = ObjectCopyUtils.copyProperties(mdm,upmdm,true);
      }
      return XfR.ok(mdmServiceImpl.updateById(upmdm));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mdms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mdmServiceImpl.removeById(id));
  }

  @PostMapping("/mdms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mdm");
     params.put("request", condition);

     return XfR.ok(mdmServiceImpl.querys(params));
  }

}
